<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: report
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_report($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_include_admin_menu();
    jrCore_page_banner('monthly report');

    $dat             = array();
    $dat[1]['title'] = 'graph';
    $dat[1]['class'] = 'center';
    jrCore_page_table_header($dat);

    $_rt = false;
    $off = date_offset_get(new DateTime);
    $tbl = jrCore_db_table_name('jrPayment', 'register');
    $req = "SELECT r_seller_profile_id AS pid,
                FROM_UNIXTIME(r_created + {$off}, '%M %Y') AS v,
                FROM_UNIXTIME(r_created + {$off}, '%Y%m') AS c,
                SUM(((r_quantity * r_amount) + r_shipping + r_tax) - r_refunded_amount) AS i,
                SUM(r_fee) AS f,
                SUM(r_expense) AS s,
                SUM(r_gateway_fee) AS e
            FROM {$tbl} GROUP BY c, pid ORDER BY c DESC";
    $_tm = jrCore_db_query($req, 'NUMERIC');
    if ($_tm && is_array($_tm)) {
        $_rt = array();
        foreach ($_tm as $_data) {
            $idx = $_data['c'];
            if (!isset($_rt[$idx])) {
                $_rt[$idx] = array(
                    'i' => 0,
                    'f' => 0,
                    'e' => 0,
                    's' => 0
                );
            }
            $_rt[$idx]['v'] = $_data['v'];
            $_rt[$idx]['c'] = $_data['c'];
            $_rt[$idx]['i'] += $_data['i'];
            $_rt[$idx]['e'] += $_data['e'];
            $_rt[$idx]['s'] += $_data['s'];
            if ($_data['pid'] > 0) {
                $_rt[$idx]['f'] += $_data['f'];
            }
        }
    }
    unset($_tm);

    $smarty          = new stdClass();
    $params          = array(
        'module' => 'jrPayment',
        'name'   => 'monthly_report',
        'width'  => '100%',
        'height' => '300px'
    );
    $dat             = array();
    $dat[1]['title'] = smarty_function_jrGraph_embed($params, $smarty);
    $dat[1]['class'] = 'center';
    jrCore_page_table_row($dat);
    jrCore_page_table_footer();

    $dat             = array();
    $dat[1]['title'] = 'month';
    $dat[1]['width'] = '15%';
    $dat[2]['title'] = 'gross income';
    $dat[2]['width'] = '20%';
    $dat[3]['title'] = 'expense';
    $dat[3]['width'] = '20%';
    $dat[4]['title'] = 'gateway fees';
    $dat[4]['width'] = '20%';
    $dat[5]['title'] = 'net income';
    $dat[5]['width'] = '20%';
    $dat[6]['title'] = 'report';
    $dat[6]['width'] = '5%';
    jrCore_page_table_header($dat);

    if ($_rt && is_array($_rt)) {
        foreach ($_rt as $_m) {
            $dat             = array();
            $dat[1]['title'] = $_m['v'];
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_m['i']);
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_m['f'] + $_m['s']);
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_m['e']);
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_m['i'] - $_m['f'] - $_m['e'] - $_m['s']);
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = jrCore_page_button("month-{$_m['c']}", 'report', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/report_detail/date={$_m['c']}')");
            $dat[6]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
