<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: system_reset
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_system_reset($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_banner('reset test data');

    // Form init
    $_tmp = array(
        'submit_value'  => 'reset selected options',
        'cancel'        => 'referrer',
        'submit_title'  => 'reset selected options?',
        'submit_prompt' => 'This will delete all test data for the selected options!',
    );
    jrCore_form_create($_tmp);

    $_opts = array(
        'reset_cart'     => array('reset cart data', 'delete all existing cart data', 'on'),
        'reset_register' => array('reset payment register', 'delete all existing register data', 'on'),
        'reset_payout'   => array('reset profile payouts', 'delete all existing profile payout data', 'on'),
        'reset_meta'     => array('reset user meta data', 'delete all existing user meta data', 'on')
    );
    $_opts = jrCore_trigger_event('jrPayment', 'system_reset_options', $_opts);

    foreach ($_opts as $name => $_inf) {
        $_tmp = array(
            'name'     => $name,
            'label'    => $_inf[0],
            'help'     => $_inf[1],
            'type'     => 'checkbox',
            'validate' => 'onoff',
            'default'  => $_inf[2],
            'required' => true
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();
}
