<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: txn_assign_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_txn_assign_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_post['txn_id']) || !jrCore_checktype($_post['txn_id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid transaction id');
        jrCore_form_result();
    }
    $tid = (int) $_post['txn_id'];
    if (!isset($_post['user_id']) || !jrCore_checktype($_post['user_id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid user_id');
        jrCore_form_result();
    }
    $uid = (int) $_post['user_id'];
    $_tr = jrCore_db_get_item('jrPayment', $tid, true);
    if (!$_tr || !is_array($_tr)) {
        jrCore_set_form_notice('error', 'invalid transaction id - data not found');
        jrCore_form_result();
    }

    $_up = array(
        'txn_user_id' => $uid
    );
    if (jrCore_db_update_item('jrPayment', $tid, $_up, null, false)) {
        // Update transaction in register
        $tbl = jrCore_db_table_name('jrPayment', 'register');
        $req = "UPDATE {$tbl} SET r_purchase_user_id = {$uid} WHERE r_txn_id = {$tid} LIMIT 1";
        $cnt = jrCore_db_query($req, 'COUNT');
        if ($cnt === 1) {
            jrCore_form_delete_session();
            jrCore_location($_post['return_url']);
        }
    }
    jrCore_set_form_notice('error', 'An error was encountered assigning the user_id to the transaction');
    jrCore_form_result();
}
