<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: txn_detail
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_txn_detail($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_session_require_login();
    jrUser_admin_only();
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid transaction id');
        jrCore_location('referrer');
    }
    if (!$_tr = jrCore_db_get_item('jrPayment', $_post['_1'], true)) {
        jrCore_set_form_notice('error', 'invalid transaction id - data not found');
        jrCore_location('referrer');
    }
    ksort($_tr);
    $url = jrCore_get_local_referrer();
    if (jrUser_is_master() && (strpos($url, '/payments') || strpos($url, '/transactions') || strpos($url, 'modify_register') || strpos($url, 'browser_item_update'))) {
        jrCore_page_admin_tabs('jrPayment', 'payments');
        jrCore_page_include_admin_menu();
        $add = '';
        if (strpos($url, '/p=')) {
            // We're coming from a page beyond one in the transaction browser
            $page = substr($url, strpos($url, '/p=') + 1);
            list(, $page) = explode('=', $page);
            $page = (int) $page;
            if ($page > 1) {
                $add = "/p={$page}";
            }
        }
        if (strpos($url, 'transactions/type=all')) {
            $cancel = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/transactions/type=all{$add}";
        }
        else {
            $cancel = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/payments{$add}";
        }
    }
    else {
        $cancel = 'referrer';
        if (jrUser_is_admin() && isset($_post['user_id']) && jrCore_checktype($_post['user_id'], 'number_nz')) {
            $_us = jrCore_db_get_item('jrUser', $_post['user_id']);
            if (!isset($_us) || !is_array($_us)) {
                if (jrUser_is_master()) {
                    jrCore_page_include_admin_menu();
                }
                jrUser_account_tabs('items');
                jrCore_notice_page('error', 'invalid id - please pass in a valid user_id');
            }
            if ($_us['user_name'] != $_user['user_name']) {
                jrCore_set_form_notice('notice', "You are viewing the purchases for the user <strong>{$_us['user_name']}</strong>", false);
            }
        }
        else {
            $_us = $_user;
        }

        if (jrUser_is_admin()) {
            jrUser_account_tabs('purchases', $_us);
        }
        else {
            jrUser_account_tabs('purchases');
        }
    }

    // Get all register entries for this transaction
    $_re = false;
    if (isset($_tr['txn_id']) && strlen($_tr['txn_id']) > 0) {
        $_re = jrPayment_get_register_entries_by_gateway_id($_tr['txn_id']);
    }

    // Get custom transaction buttons
    $_buttons = array(
        jrCore_page_button('delete', 'delete', "jrCore_confirm('Delete Transaction?', 'All entries for this transaction will be removed', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/txn_delete/{$_tr['_item_id']}') });")
    );
    if (!empty($_tr['txn_expense'])) {
        $_buttons[] = jrCore_page_button('modify', 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/modify_register_entry/{$_tr['_item_id']}')");
    }
    elseif (jrUser_is_master()) {
        $_buttons[] = jrCore_page_button('modify', 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/browser_item_update/id={$_tr['_item_id']}')");
    }

    if (isset($_tr['txn_plugin'])) {
        jrPayment_set_active_plugin($_tr['txn_plugin']);
        if ($url = jrPayment_run_plugin_function('get_transaction_url', $_tr)) {
            $_buttons[] = jrCore_page_button('view', 'view @ ' . $_tr['txn_plugin'], "window.open('{$url}')");
        }
        if ($_re && count($_re) > 0) {
            if ($_tmp = jrPayment_run_plugin_function('txn_detail_buttons', $_tr, $_re)) {
                if (is_array($_tmp)) {
                    $_buttons = array_merge($_tmp, $_buttons);
                }
            }
        }
    }
    jrPayment_set_active_plugin($_conf['jrPayment_plugin']);

    // Show raw Transaction
    jrCore_page_banner('transaction detail', implode('', $_buttons));

    if (isset($_tr['txn_user_id']) && jrCore_checktype($_tr['txn_user_id'], 'number_nz')) {

        $dat             = array();
        $dat[1]['title'] = 'User';
        $dat[1]['width'] = '10%';
        $dat[2]['title'] = 'Details';
        $dat[2]['width'] = '90%';

        jrCore_page_table_header($dat);
        $uid = (int) $_tr['txn_user_id'];
        $_us = jrCore_db_get_item('jrUser', $uid);

        $dat             = array();
        $_im             = array(
            'crop'   => 'auto',
            'alt'    => (isset($_us['user_name'])) ? $_us['user_name'] : 'user image',
            'title'  => (isset($_us['user_name'])) ? $_us['user_name'] : 'user image',
            'width'  => 160,
            'height' => 160,
            '_v'     => (isset($_us['user_image_time']) && $_us['user_image_time'] > 0) ? $_us['user_image_time'] : $_us['_created']
        );
        $dat[1]['title'] = jrImage_get_image_src('jrUser', "user_image", $uid, 'large', $_im);
        if (count($_us) > 0) {
            $num = '';
            if (isset($_re) && is_array($_re)) {
                $num = '<br>' . count($_re) . ' items';
            }
            $dat[2]['title'] = $_us['user_name'] . "<br><a href=\"{$_conf['jrCore_base_url']}/{$_us['profile_url']}\">@{$_us['profile_url']}</a><br>" . jrCore_format_time($_re[0]['r_created']) . $num;
        }
        else {
            $dat[2]['title'] = '(visitor)';
        }
        $dat[2]['class'] = 'p10';
        jrCore_page_table_row($dat);

        $dat             = array();
        $dat[1]['title'] = 'Key';
        $dat[2]['title'] = 'Value';
        jrCore_page_table_header($dat, null, true);

    }
    else {

        $dat             = array();
        $dat[1]['title'] = 'Key';
        $dat[1]['width'] = '10%';
        $dat[2]['title'] = 'Value';
        $dat[2]['width'] = '90%';
        jrCore_page_table_header($dat);

    }

    foreach ($_tr as $k => $v) {
        $dat             = array();
        $dat[1]['title'] = $k;
        switch ($k) {
            case '_item_id':
            case '_user_id':
            case '_profile_id':
            case 'txn_raw':
            case 'txn_note':   // We handle this one separately below
                continue 2;
            case '_created':
            case '_updated':
            case 'txn_date':
                $dat[2]['title'] = jrCore_format_time($v);
                break;
            case 'txn_gateway_fee':
            case 'txn_shipping':
            case 'txn_total':
            case 'txn_amount':
            case 'txn_expense':
            case 'txn_fee':
            case 'txn_tax':
            case 'txn_charge':
                $dat[2]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($v);
                break;
            default:
                $dat[2]['title'] = $v;
                break;
        }
        jrCore_page_table_row($dat);
    }

    if (!empty($_tr['txn_note'])) {
        $dat[1]['title'] = 'txn_note';
        $dat[2]['title'] = nl2br(trim($_tr['txn_note']));
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    if ($_tr['txn_type'] != 'information' && $_re && is_array($_re)) {

        // Show individual items
        $dat[1]['title'] = '';
        $dat[1]['width'] = '2%';
        $dat[2]['title'] = 'item';
        $dat[2]['width'] = '68%';
        $dat[3]['title'] = 'date';
        $dat[3]['width'] = '15%';
        $dat[4]['title'] = 'amount';
        $dat[4]['width'] = '15%';
        jrCore_page_table_header($dat);

        $_re = jrPayment_get_data_for_items($_re);

        foreach ($_re as $_r) {

            $_it = $_r['r_item_data'];
            $pfx = jrCore_db_get_prefix($_r['r_module']);
            $dat = array();
            if ($_r['r_module'] != 'jrPayment') {
                if (jrCore_is_datastore_module($_r['r_module'])) {
                    $_im             = array(
                        'crop'   => 'auto',
                        'alt'    => $_it["{$pfx}_title"],
                        'title'  => $_it["{$pfx}_title"],
                        'width'  => 48,
                        'height' => 48,
                        '_v'     => (isset($_it["{$pfx}_image_time"]) && $_it["{$pfx}_image_time"] > 0) ? $_it["{$pfx}_image_time"] : $_r['r_created']
                    );
                    $dat[1]['title'] = jrImage_get_image_src($_r['r_module'], "{$pfx}_image", $_r['r_item_id'], 'icon', $_im);
                }
                else {
                    $dat[1]['title'] = jrCore_get_module_icon_html($_r['r_module'], 48);
                }
            }
            else {
                $dat[1]['title'] = jrCore_get_module_icon_html('jrPayment', 48);
            }
            $dat[2]['title'] = '<a href="' . $_conf['jrCore_base_url'] . '/' . $_it['profile_url'] . '/' . jrCore_get_module_url($_r['r_module']) . '">' . $_mods["{$_r['r_module']}"]['module_name'] . '</a> - ' . $_it["{$pfx}_title"] . '<br><small><a href="' . $_conf['jrCore_base_url'] . '/' . $_it['profile_url'] . '">@' . $_it['profile_url'] . '</a></small>';
            $dat[3]['title'] = jrCore_format_time($_r['r_created']);
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrPayment_get_currency_entity($_r['r_currency']) . jrPayment_currency_format($_r['r_amount']);
            if (isset($_r['r_refunded']) && $_r['r_refunded'] == 1) {
                $dat[4]['title'] .= '<br><small>refunded</small>';
                $dat[4]['class'] = 'error center';
            }
            else {
                $dat[4]['class'] = 'center';
            }

            // Trigger so individual modules can customize their row if needed
            $dat = jrCore_trigger_event('jrPayment', 'txn_detail_entry', $dat, array_merge($_tr, $_r), $_r['r_module']);
            if ($dat && is_array($dat) && count($dat) > 0) {
                jrCore_page_table_row($dat);
            }
        }
        jrCore_page_table_footer();
    }

    if (isset($_tr['txn_raw'])) {
        if ($_raw = json_decode($_tr['txn_raw'], true)) {

            $dat             = array();
            $dat[1]['title'] = 'Parsed Webhook';
            $dat[1]['width'] = '100%';
            jrCore_page_table_header($dat);

            $dat             = array();
            $dat[1]['title'] = '<div class="fixed-width">' . str_replace(',', ', ', jrCore_entity_string(print_r($_raw, true))) . '</div>';
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_footer();
    }

    jrCore_page_cancel_button($cancel);
    jrCore_page_display();
}
