// Jamroom Playlist Module Javascript
// @copyright 2003-2013 by Talldude Networks LLC

/**
 * Show the playlist drop down
 * @param int id Item ID
 * @param string mod Module
 * @param int pn Page Number
 */
function jrPlaylist_select(id, mod, pn)
{
    var p = $('#playlist_' + mod + '_' + id);
    if (typeof pn == "undefined" || pn == null) {
        pn = 1;
    }
    if (p.is(':hidden')) {
        $('.overlay').hide();
    }
    var u = core_system_url + '/' + jrPlaylist_url + '/add/' + mod + '/' + Number(id) + '/p=' + Number(pn) + '/__ajax=1';
    jrCore_set_csrf_cookie(u);
    $.get(u, function(r) {
        jrPlaylist_position(mod, id);
        p.html(r).fadeIn(200);
    });
}

/**
 * Position the playlist drop down on the page
 * @param string mod
 * @param int iid
 */
function jrPlaylist_position(mod, iid)
{
    var bid = $('#playlist_button_' + mod + '_' + iid);
    var bpr = $(window).width() - bid.offset().left;
    var bpt = bid.offset().top;
    $('#playlist_' + mod + '_' + iid).appendTo('body').css({'position': 'absolute', 'right': (bpr - 35) + 'px', 'top': (bpt + 35) + 'px'});
}

/**
 * remove an item from a playlist
 * @param {string} dom DOM ID of item to remove on success
 * @param {int} pid Playlist id (will be string for non logged in users)
 * @param {string} mod Module Item belongs to
 * @param {int} iid Item ID of item being removed
 */
function jrPlaylist_remove(dom, pid, mod, iid)
{
    var u = core_system_url + '/' + jrPlaylist_url + '/remove_save';
    jrCore_set_csrf_cookie(u);
    $.post(u, {playlist_id: pid, playlist_for: mod, item_id: iid}, function(r) {
        if (r.success) {
            $(dom).slideUp(150, function() {
                $(dom).remove();
            });
        }
        else {
            jrCore_alert('error received trying to remove item: ' + r.error_msg);
        }
    }, 'json');
}

/**
 * Add an item to a playlist
 * @param int pid
 * @param int iid
 * @param string mod
 */
function jrPlaylist_inject(pid, iid, mod)
{
    var b = $('.playlist_button');
    b.jrCore_disable_button();
    var u = core_system_url + '/' + jrPlaylist_url + '/inject_save/__ajax=1';
    jrCore_set_csrf_cookie(u);
    $.post(u, {playlist_id: pid, item_id: iid, playlist_for: mod}, function(r) {
        b.jrCore_enable_button();
        if (r.success) {
            jrPlaylist_hide();
        }
        else {
            $('#playlist_message').addClass('playlist_error').text(r.success_msg);
        }
    }, 'json');
}

/**
 * add the selected item to the playlist
 */

/**
 * Add an item to a playlist
 * @param int iid
 * @param string mod
 */
function jrPlaylist_new(iid, mod)
{
    var b = $('.playlist_button');
    var i = $('#playlist_indicator');
    b.jrCore_disable_button();
    i.show();
    setTimeout(function() {
        var x = $('#new_playlist_' + iid);
        var t = x.val();
        if (t.length > 0) {
            var u = core_system_url + '/' + jrPlaylist_url + '/add_save/__ajax=1';
            jrCore_set_csrf_cookie(u);
            $.post(u, {title: t, item_id: iid, playlist_for: mod}, function(r) {
                var m = $('#playlist_message');
                if (r.success) {
                    m.addClass('success').text(r.success_msg).show();
                    setTimeout(function() {
                        jrPlaylist_hide();
                        i.hide();
                        b.jrCore_enable_button();
                    }, 1200);
                }
                else {
                    i.hide();
                    m.addClass('error').text(r.success_msg).show();
                    b.jrCore_enable_button();
                }
            }, 'json');

        }
        else {
            i.hide();
            b.jrCore_enable_button();
            x.addClass('error');
        }
    }, 1000);
}

/**
 * the X button to hide the playlist list box.
 */
function jrPlaylist_hide()
{
    $(".playlist_box").fadeOut(100);
}
