<?php
 /**
 * Jamroom Products module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2003 - 2017 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

//------------------------------
// shipping tracker
//------------------------------
function profile_view_jrProduct_shipping_tracker($_profile, $_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrUser_check_quota_access('jrProduct');
    $_ln = jrUser_load_lang_strings();

    // Banner
    jrCore_page_banner($_ln['jrProduct'][48]);

    $pid = (int) $_profile['_profile_id'];
    $tbl = jrCore_db_table_name('jrPayment', 'register');
    $req = "SELECT * FROM {$tbl} WHERE r_seller_profile_id = {$pid} AND r_module = 'jrProduct' ORDER BY r_id DESC";
    $_rt = jrCore_db_paged_query($req, 0, 12);
    if ($_rt && is_array($_rt['_items']) && count($_rt['_items']) > 0) {

        // Add additional info to array
        $_uid = array();
        $_tmp = array();
        foreach ($_rt['_items'] as $k => $rt) {
            $_tmp[]     = (int) $rt['r_txn_id'];
            $uid        = (int) $rt['r_purchase_user_id'];
            $_uid[$uid] = $uid;
            if (!empty($rt['r_item_data'])) {
                $_rt['_items'][$k]['_product'] = json_decode($rt['r_item_data'], true);
            }
        }
        if (count($_tmp) > 0) {
            if ($_payments = jrCore_db_get_multiple_items('jrPayment', $_tmp, null, false, '_item_id')) {
                foreach ($_rt['_items'] as $k => $rt) {
                    if (isset($_payments["{$rt['r_txn_id']}"])) {
                        $_rt['_items'][$k]['_payment'] = $_payments["{$rt['r_txn_id']}"];
                    }
                }
            }
        }
        if (count($_uid) > 0) {
            if ($_users = jrCore_db_get_multiple_items('jrUser', $_uid, null, false, '_item_id')) {
                foreach ($_rt['_items'] as $k => $rt) {
                    if (isset($_users["{$rt['r_purchase_user_id']}"])) {
                        $_rt['_items'][$k]['_user'] = $_users["{$rt['r_purchase_user_id']}"];
                    }
                }
            }
        }

        // Output the modal forms
        $html = jrCore_parse_template('tracking_info.tpl', $_rt, 'jrProduct');
        jrCore_page_custom($html);

        // Output Table
        $dat             = array();
        $dat[0]['title'] = '&nbsp;';
        $dat[0]['width'] = '5%';
        $dat[1]['title'] = $_ln['jrProduct'][50];
        $dat[1]['width'] = '40%';
        $dat[2]['title'] = $_ln['jrProduct'][51];
        $dat[2]['width'] = '5%;';
        $dat[3]['title'] = $_ln['jrProduct'][52];
        $dat[3]['width'] = '40%';
        $dat[4]['title'] = $_ln['jrProduct'][54];
        $dat[4]['width'] = '5%';
        $dat[5]['title'] = $_ln['jrProduct'][55];
        $dat[5]['width'] = '5%';
        jrCore_page_table_header($dat);
        foreach ($_rt['_items'] as $k => $rt) {

            if (jrCore_module_is_active('jrPrivateNote')) {
                // @note: no need to check if recipient is a valid private note user here - the Private Note "new" view will check for us
                $pnurl = jrCore_get_module_url('jrPrivateNote');
                $cbttn = jrCore_page_button("shipping-contact-{$k}", $_ln['jrProduct'][55], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$pnurl}/new/user_id={$rt['r_purchase_user_id']}')");
            }
            elseif (!empty($rt['_user']['user_email']) && jrCore_checktype($rt['_user']['user_email'], 'email')) {
                $cbttn = jrCore_page_button("contact_{$rt['r_id']}", $_ln['jrProduct'][55], "window.location.href = 'mailto:{$rt['_user']['user_email']}'");
            }
            else {
                $cbttn = jrCore_page_button("contact_{$rt['r_id']}", $_ln['jrProduct'][55], "", array('class' => "form_button form_button_disabled", 'disabled' => 'disabled'));
            }
            $att  = (isset($rt['_payment']["txn_tracking_info_{$rt['r_id']}"])) ? "{$rt['_payment']["txn_tracking_info_{$rt['r_id']}"]}" : $_ln['jrProduct'][57];
            $_att = array(
                'title' => $att,
                'alt'   => $att
            );

            if (jrCore_is_datastore_module($rt['r_module'])) {
                $_im             = array(
                    'crop'   => 'auto',
                    'alt'    => $rt['_product']['product_title'],
                    'title'  => $rt['_product']['product_title'],
                    'width'  => 72,
                    'height' => 72,
                    '_v'     => $rt['_product']['_updated']
                );
                $dat[0]['title'] = jrImage_get_image_src($rt['r_module'], 'product_image', $rt['r_item_id'], 'icon', $_im);
            }
            else {
                $dat[0]['title'] = jrCore_get_module_icon_html($rt['r_module'], 72);
            }
            $dat[1]['title'] = '<h3>' . $rt['_product']['product_title'] . '</h3><br>' . jrCore_format_time($rt['r_created']);
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = $rt['r_quantity'];
            $dat[2]['class'] = 'center';

            $dat[3]['title'] = jrProduct_get_user_name($rt) . '<br>' . jrProduct_get_user_address($rt['_payment']);
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_page_button("ti_{$rt['r_id']}", $_ln['jrProduct'][54], "$('#tracking_info_modal_{$rt['r_id']}').modal()", $_att);

            $key = 'txn_tracking_info_' . $rt['r_id'];
            if (!empty($rt['_payment'][$key])) {
                $count = count(preg_split('/\W+/', $rt['_payment'][$key], -1, PREG_SPLIT_NO_EMPTY));
                if ($count === 1 && !jrCore_checktype($rt['_payment'][$key], 'url')) {
                    if ($url = jrProduct_get_tracking_url($rt['_payment'][$key])) {
                        $dat[4]['title'] .= "<br><span class=\"product-carrier\"><a href=\"{$url}\" target=\"_blank\"><u>" . jrProduct_get_carrier_from_tracking_url($url) . "</u></a></span>";
                    }
                    else {
                        $dat[4]['title'] .= "<br><span class=\"product-carrier\">" . $rt['_payment'][$key] . '</span>';
                    }
                }
                $dat[4]['class'] = 'center success product-tracking-cell';
            }
            else {
                $dat[4]['class'] = 'center error';
            }
            $dat[5]['title'] = $cbttn;
            $dat[5]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
        jrCore_page_table_footer();
    }
    else {
        jrCore_page_note("No products sold");
    }
    return jrCore_page_display(true);
}

//------------------------------
// categories
//------------------------------
function profile_view_jrProduct_categories($_profile, $_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrUser_check_quota_access('jrProduct');
    $_ln = jrUser_load_lang_strings();

    // if the user does not belong to this profile, show not authorized
    if (!jrProfile_is_profile_owner($_profile['_profile_id'])) {
        jrUser_not_authorized();
    }

    // Banner
    $url = jrCore_get_module_url('jrProduct');
    $tmp = jrCore_page_button('create', $_ln['jrProduct'][20], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/create_category')");
    jrCore_page_banner($_ln['jrProduct'][26], $tmp);

    // Get all categories for items belonging to this profile
    $_it = false;
    $_sc = array(
        'search'         => array(
            "_profile_id = {$_profile['_profile_id']}"
        ),
        'return_keys'    => array('product_category_url'),
        'skip_triggers'  => true,
        'ignore_pending' => true,
        'privacy_check'  => false,
        'limit'          => 50000
    );
    $_sc = jrCore_db_search_items('jrProduct', $_sc);
    if ($_sc && is_array($_sc) && isset($_sc['_items'])) {
        $_it = array();
        foreach ($_sc['_items'] as $c) {
            if (!isset($_it["{$c['product_category_url']}"])) {
                $_it["{$c['product_category_url']}"] = 0;
            }
            $_it["{$c['product_category_url']}"]++;
        }
    }

    $tbl = jrCore_db_table_name('jrProduct', 'category');
    $req = "SELECT * FROM {$tbl} WHERE cat_profile_id = '{$_profile['_profile_id']}' ORDER BY cat_title ASC";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if ($_rt && is_array($_rt) && count($_rt) > 0) {
        // Show all user categories
        foreach ($_rt as $k => $rt) {
            $count = (isset($_it["{$rt['cat_title_url']}"])) ? intval($_it["{$rt['cat_title_url']}"]) : 0;
            if ($count > 0) {
                $tmp = jrCore_page_button("count{$k}", $_ln['jrProduct'][43] . ': ' . $count, "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_profile['profile_url']}/{$url}/category/{$rt['cat_title_url']}')");
            }
            else {
                $tmp = jrCore_page_button("count{$k}", $_ln['jrProduct'][43] . ': 0', 'disabled');
            }
            $tmp .= jrCore_page_button("update{$k}", $_ln['jrProduct'][29], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/update_category/id={$rt['cat_id']}')");
            if ($count > 0) {
                $tmp .= jrCore_page_button("delete{$rt['cat_id']}", $_ln['jrProduct'][30], 'disabled');
            }
            else {
                $tmp .= jrCore_page_button("delete{$rt['cat_id']}", $_ln['jrProduct'][30], "jrCore_confirm('{$_ln['jrProduct'][31]}','',function(){jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/delete_category/id={$rt['cat_id']}')})");
            }
            jrCore_page_banner('&bull; ' . $rt['cat_title'], $tmp);
        }
    }
    else {
        jrCore_page_note($_ln['jrProduct'][27]);
    }
    jrCore_page_title($_ln['jrProduct'][26]);
    return jrCore_page_display(true);
}

//------------------------------
// default
//------------------------------
function profile_view_jrProduct_default($_profile, $_post, $_user, $_conf)
{
    if (isset($_post['option']) && $_post['option'] == 'category') {

        // We are viewing a specific category _2 is our cat
        if (!isset($_post['_2']) || strlen($_post['_2']) === 0) {
            jrCore_page_not_found();
        }
        if (!$_cat = jrProduct_get_category_by_url($_profile['_profile_id'], $_post['_2'])) {
            jrCore_page_not_found();
        }
        $_profile['_cat'] = $_cat;
        return jrCore_parse_template('item_category.tpl', $_profile, 'jrProduct');
    }
    return false;
}
