<?php
 /**
 * Jamroom Products module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 * @author Michael Ussher <michael [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * db_schema
 */
function jrProduct_db_schema()
{
    jrCore_db_create_datastore('jrProduct', 'product');

    // Categories
    $_tmp = array(
        "cat_id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY",
        "cat_created INT(11) UNSIGNED NOT NULL DEFAULT '0'",
        "cat_updated INT(11) UNSIGNED NOT NULL DEFAULT '0'",
        "cat_profile_id INT(11) UNSIGNED NOT NULL DEFAULT '0'",
        "cat_title VARCHAR(128) NOT NULL DEFAULT ''",
        "cat_title_url VARCHAR(128) NOT NULL DEFAULT ''",
        "cat_field TEXT NOT NULL",
        "INDEX cat_profile_id (cat_profile_id)",
        "INDEX cat_title_url (cat_title_url)",
    );
    jrCore_db_verify_table('jrProduct', 'category', $_tmp);
    return true;
}
