<?php
 /**
 * Jamroom Products module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * lib/util.php unit tests
 */
function test_jrProduct_tracking_ids()
{
    $_ids = array(
        '4221736293'                 => 'DHL',
        'D10010910272361'            => 'OnTrac',
        '9612804882227378545377'     => 'FedEx',
        '1Z204E380338943508'         => 'UPS',
        '1Z51062E6893884735'         => 'UPS',
        '1ZXF38300382722839'         => 'UPS',
        '70151520000337683171'       => 'USPS',
        '9400111899223523321287'     => 'USPS',
        '92748999984327000003259997' => 'USPS',
        '801150913401992574'         => 'USPS',
        '9305520111402983409680'     => 'USPS'
    );
    foreach ($_ids as $id => $carrier) {
        jrUnitTest_init_test("Get {$carrier} ID: {$id}");
        if ($url = jrProduct_get_tracking_url($id)) {
            if (!jrProduct_get_carrier_from_tracking_url($url)) {
                jrUnitTest_exit_with_error();
            }
        }
        else {
            jrUnitTest_exit_with_error();
        }
    }
}
