<?php
 /**
 * Jamroom Profile Tweaks module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: customize
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfileTweaks_customize($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_session_require_login();
    jrUser_check_quota_access('jrProfileTweaks');
    if (!$_profile = jrUser_get_requested_user_account_info()) {
        jrCore_notice_page('error', 41);
    }
    jrUser_account_tabs('customize', $_profile);

    $button = null;
    if (!empty($_profile['profile_name'])) {
        $button = jrCore_page_button('account-tabs-profile-button', "@{$_profile['profile_url']}", "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_profile['profile_url']}')");
    }

    $_ln = jrUser_load_lang_strings();
    jrCore_page_banner(2, $button);
    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value'     => 3,
        'cancel'           => jrCore_is_profile_referrer(),
        'form_ajax_submit' => false,
        'values'           => $_profile
    );
    jrCore_form_create($_tmp);

    // Profile ID
    $_tmp = array(
        'name'  => 'pid',
        'type'  => 'hidden',
        'value' => intval($_profile['_profile_id'])
    );
    jrCore_form_field_create($_tmp);

    if (isset($_profile['quota_jrProfileTweaks_allow_logo']) && $_profile['quota_jrProfileTweaks_allow_logo'] == 'on') {
        // Custom Site Logo
        $_tmp = array(
            'name'         => 'profile_logo_image',
            'label'        => 16,
            'help'         => 17,
            'text'         => 18,
            'type'         => 'image',
            'allowed'      => 'jpg,jpeg,jfif,jpe,png,gif',
            'max'          => 262144,
            'image_module' => 'jrProfile',
            'image_delete' => true,
            'required'     => false
        );
        if (isset($_profile['profile_logo_image_time']) && jrCore_checktype($_profile['profile_logo_image_time'], 'number_nz')) {
            $_tmp['unique'] = $_profile['profile_logo_image_time'];
        }
        jrCore_form_field_create($_tmp);
    }

    if (isset($_profile['quota_jrProfileTweaks_allow_background_image']) && $_profile['quota_jrProfileTweaks_allow_background_image'] == 'on') {
        // Custom Background
        $_tmp = array(
            'name'         => 'profile_bg_image',
            'label'        => 4,
            'help'         => 6,
            'text'         => 7,
            'type'         => 'image',
            'allowed'      => 'jpg,jpeg,jfif,jpe',
            'image_module' => 'jrProfile',
            'image_delete' => true,
            'required'     => false
        );
        if (isset($_profile['profile_bg_image_time']) && jrCore_checktype($_profile['profile_bg_image_time'], 'number_nz')) {
            $_tmp['unique'] = $_profile['profile_bg_image_time'];
        }
        jrCore_form_field_create($_tmp);

        // Tile Image
        $_tmp = array(
            'name'     => 'profile_bg_tile',
            'label'    => 9,
            'help'     => 10,
            'type'     => 'checkbox',
            'default'  => 'off',
            'validate' => 'onoff',
            'required' => true
        );
        jrCore_form_field_create($_tmp);
    }

    if (isset($_profile['quota_jrProfileTweaks_allow_index_redirect']) && $_profile['quota_jrProfileTweaks_allow_index_redirect'] == 'on') {
        // Default Index page
        $_idx = array('0' => $_ln['jrProfileTweaks'][15]);

        // Get profile options this quota has access to
        foreach (array_keys($_mods) as $module) {
            switch ($module) {
                case 'jrCore':
                case 'jrProfile':
                case 'jrUser':
                case 'jrMailer':
                case 'jrComment':
                    continue 2;
                default:
                    // Module is NOT active
                    if (!jrCore_module_is_active($module)) {
                        continue 2;
                    }
                    // See if this Profile's Quota allows access to the module
                    if (isset($_profile["quota_{$module}_allowed"]) && $_profile["quota_{$module}_allowed"] != 'on') {
                        continue 2;
                    }
                    // Our module must have an item_index.tpl file...
                    if (!is_file(APP_DIR . "/modules/{$module}/templates/item_index.tpl")) {
                        continue 2;
                    }
                    $_idx[$module] = $_mods[$module]['module_name'];
                    break;
            }
        }

        if (count($_idx) > 0) {
            natcasesort($_idx);
        }

        // Add in pages
        if (jrCore_module_is_active('jrPage') && isset($_profile['quota_jrPage_allowed']) && $_profile['quota_jrPage_allowed'] == 'on') {
            $_sc = array(
                'search'        => array(
                    "_profile_id = {$_profile['_profile_id']}",
                    "page_location = 1"
                ),
                'return_keys'   => array('_item_id', 'page_title'),
                'skip_triggers' => true,
                'privacy_check' => false,
                'limit'         => 100
            );
            $_pg = jrCore_db_search_items('jrPage', $_sc);
            if ($_pg && is_array($_pg) && isset($_pg['_items']) && is_array($_pg['_items'])) {
                $_ln = jrUser_load_lang_strings();
                foreach ($_pg['_items'] as $_itm) {
                    $_idx["jrPage:{$_itm['_item_id']}"] = "{$_ln['jrProfileTweaks'][14]}: {$_itm['page_title']}";
                }
            }
        }

        if (count($_idx) > 0) {
            $_tmp = array(
                'name'     => 'profile_index_page',
                'label'    => 11,
                'help'     => 12,
                'type'     => 'select',
                'options'  => $_idx,
                'default'  => (isset($_profile['quota_jrProfileTweaks_default_index'])) ? $_profile['quota_jrProfileTweaks_default_index'] : '0',
                'value'    => (isset($_profile['profile_index_page'])) ? $_profile['profile_index_page'] : '0',
                'required' => false
            );
            jrCore_form_field_create($_tmp);
        }
    }

    // Custom Skin
    if (isset($_profile['quota_jrProfileTweaks_allow_skin']) && strlen($_profile['quota_jrProfileTweaks_allow_skin']) > 0) {
        $_sk = explode(',', $_profile['quota_jrProfileTweaks_allow_skin']);
        if ($_sk && is_array($_sk) && count($_sk) > 0) {
            $_opt = array();
            foreach ($_sk as $skin) {
                $_tm = jrCore_skin_meta_data($skin);
                if ($_tm && is_array($_tm)) {
                    $_opt[$skin] = $_tm['title'];
                }
            }

            // If a QUOTA CONFIG default has been set, its the default
            if (strpos(' ,' . $_profile['quota_jrProfileTweaks_allow_skin'] . ',', ',' . $_profile['quota_jrProfileTweaks_default_skin'] . ',')) {
                $_opt[$_profile['quota_jrProfileTweaks_default_skin']] .= ' ' . $_ln['jrProfileTweaks'][21];
                $default                                               = $_profile['quota_jrProfileTweaks_default_skin'];

                // a custom skin had been set, but its no longer an option in this quota
                if (!isset($_profile['profile_custom_skin']) || !strpos(' ,' . $_profile['quota_jrProfileTweaks_allow_skin'] . ',', ',' . $_profile['profile_custom_skin'] . ',')) {
                    $_profile['profile_custom_skin'] = $default;
                }
            }
            else {
                // otherwise, if Admin Skin is active and set, its the default
                if (jrCore_module_is_active('jrAdminSkin') && isset($_conf['jrAdminSkin_profile_skin']) && $_conf['jrAdminSkin_profile_skin'] != $_conf['jrCore_active_skin']) {
                    $default = $_conf['jrAdminSkin_profile_skin'];
                }
                else {
                    // or else fall back to the main skin as default.
                    $default = $_conf['jrCore_active_skin'];
                }

                if (!isset($_opt[$default])) {
                    $_tm            = jrCore_skin_meta_data($default);
                    $_opt[$default] = $_tm['title'];
                }
                $_opt[$default] .= ' ' . $_ln['jrProfileTweaks'][21];
            }

            $_tmp = array(
                'name'     => 'profile_custom_skin',
                'label'    => 19,
                'help'     => 20,
                'type'     => 'select',
                'options'  => $_opt,
                'default'  => $_conf['jrCore_active_skin'],
                'value'    => (isset($_profile['profile_custom_skin'])) ? $_profile['profile_custom_skin'] : $default,
                'required' => false
            );
            jrCore_form_field_create($_tmp);
        }
    }

    jrCore_page_display();
}
