<?php
 /**
 * Jamroom URL Redirection module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: default
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrRedirect_default($_post, $_user, $_conf)
{
    global $_urls;
    if (!empty($_post['option'])) {

        // Check if this is a shorted URL for an item - option will be 12 characters long
        // http://site.com/r/audio/<short_code>
        if (isset($_urls["{$_post['option']}"]) && isset($_post['_1']) && strlen($_post['_1']) === 12) {
            // We have a Short URL - redirect
            $mod = $_urls["{$_post['option']}"];
            if ($pfx = jrCore_db_get_prefix($mod)) {
                if ($_it = jrCore_db_get_item_by_key($mod, "{$pfx}_short_url_code", $_post['_1'])) {

                    // We have a match - increment redirect count
                    jrCore_db_increment_key($mod, $_it['_item_id'], "{$pfx}_short_url_redirect_count", 1);

                    // And redirect the viewer to the right page
                    // NOTE: jrPage is hard coded here since it is the only module that supports both "site" and "profile"
                    if ($mod == 'jrPage' && isset($_it['page_location']) && $_it['page_location'] == '0') {
                        $url = "{$_conf['jrCore_base_url']}/{$_post['option']}/{$_it['_item_id']}";
                    }
                    else {
                        $url = "{$_conf['jrCore_base_url']}/{$_it['profile_url']}/{$_post['option']}/{$_it['_item_id']}";
                    }
                    if (isset($_it["{$pfx}_title_url"])) {
                        $url .= '/' . $_it["{$pfx}_title_url"];
                    }

                    header('HTTP/1.1 301 Moved Permanently');
                    jrCore_location($url);
                }
                else {
                    // Item no longer exists - redirect to main site page
                    jrCore_location($_conf['jrCore_base_url']);
                }
            }
        }

        // Fall through - see if we match a created URL
        $_tm = jrCore_db_get_item_by_key('jrRedirect', 'r_view', $_post['option'], true);
        if ($_tm && is_array($_tm)) {
            if (!jrUser_is_admin() && strlen(jrUser_get_bot_name()) === 0) {
                // Only count non-admin and non-bot referrals
                jrRedirect_count_hit($_tm['_item_id']);
            }
            jrCore_location($_tm['r_url']);
        }
    }

    jrCore_location($_conf['jrCore_base_url']);
}
