<?php
 /**
 * Jamroom Redis Cache module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2014 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * config
 */
function jrRedis_config()
{
    // Timeout
    $_opt = array(
        '0.10' => '0.10 second',
        '0.15' => '0.15 second',
        '0.20' => '0.20 second',
        '0.25' => '0.25 second',
        '0.30' => '0.30 second',
        '0.40' => '0.40 second',
        '0.50' => '0.50 second',
        '0.75' => '0.75 second',
        '1.0'  => '1.00 second'
    );
    $_tmp = array(
        'name'     => 'timeout',
        'type'     => 'select',
        'options'  => $_opt,
        'default'  => '0.50',
        'validate' => 'number_nz',
        'label'    => 'Connect Timeout',
        'help'     => 'How long will the client wait for an accepted connection to the Redis Server?',
        'order'    => 1
    );
    jrCore_register_setting('jrRedis', $_tmp);

    // Fallback
    $_tmp = array(
        'name'     => 'fallback',
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => 'Core Fallback Enabled',
        'help'     => 'If this option is checked, and the Redis server is detected as being down, the module will revert the request to use the Core Cache or User Sessions',
        'order'    => 2
    );
    jrCore_register_setting('jrRedis', $_tmp);

    // Single Site
    $_tmp = array(
        'name'     => 'single_site',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff',
        'label'    => 'Single Site Enabled',
        'help'     => 'Check this option if this Jamroom site is the only site using the Redis server - this will speed up some cache delete functions',
        'order'    => 3
    );
    jrCore_register_setting('jrRedis', $_tmp);

    //---------------------------------
    // Internal settings
    //---------------------------------

    // Config
    $_tmp = array(
        'name'     => 'config',
        'type'     => 'hidden',
        'default'  => '',
        'validate' => 'not_empty',
        'label'    => 'Configured Servers',
        'help'     => 'This internal field holds the active Redis config - do not modify',
        'order'    => 20
    );
    jrCore_register_setting('jrRedis', $_tmp);

    jrCore_delete_setting('jrRedis', 'password');
    jrCore_delete_setting('jrRedis', 'server');
    jrCore_delete_setting('jrRedis', 'port');
    jrCore_delete_setting('jrRedis', 'db');

    return true;
}

/**
 * Advanced Config keys
 */
function jrRedis_advanced_config()
{
    jrCore_register_advanced_config_key('jrRedis', 'key_prefix', '', "When running in a multi server setting, the default key prefix can be overridden - set it here to a 5 character string (letters only)");
    return true;
}
