<?php
 /**
 * Jamroom Redis Cache module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: server_browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrRedis_server_browse($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrRedis', 'server_browse');
    jrCore_page_banner('Redis Servers');

    $pass = jrCore_get_option_image('pass');
    $fail = jrCore_get_option_image('fail');

    // Get existing cache servers
    if (jrCore_module_is_active('jrCloudClient')) {

        jrCore_page_notice('success', "The Redis Server Configuration is controlled by the <b>Cluster Master</b>", false);

        $dat             = array();
        $dat[1]['title'] = 'name';
        $dat[1]['width'] = '32%';
        $dat[2]['title'] = 'host';
        $dat[2]['width'] = '32%';
        $dat[3]['title'] = 'port';
        $dat[3]['width'] = '10%';
        $dat[4]['title'] = 'cache';
        $dat[4]['width'] = '10%';
        $dat[5]['title'] = 'session';
        $dat[5]['width'] = '10%';
        $dat[6]['title'] = 'stats';
        $dat[6]['width'] = '6%';
        jrCore_page_table_header($dat);

        $_rt = jrCloudClient_get_cluster_config();
        if ($_rt && is_array($_rt) && isset($_rt['redis'])) {
            $k = 0;
            foreach ($_rt['redis'] as $_server) {
                $dat             = array();
                $dat[1]['title'] = $_server['server_name'];
                $dat[1]['class'] = 'center';
                $dat[2]['title'] = $_server['server_host'];
                $dat[2]['class'] = 'center';
                $dat[3]['title'] = (isset($_server['server_port'])) ? $_server['server_port'] : 19379;
                $dat[3]['class'] = 'center';
                $dat[4]['title'] = ($_server['redis_cache'] == 'on') ? $pass : $fail;
                $dat[4]['class'] = 'center';
                $dat[5]['title'] = ($_server['redis_session'] == 'on') ? $pass : $fail;
                $dat[5]['class'] = 'center';
                $dat[6]['title'] = jrCore_page_button("rinfo-{$k}", 'stats', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/server_info/id={$k}')");
                jrCore_page_table_row($dat);
                $k++;
            }
        }
        else {
            $dat             = array();
            $dat[1]['title'] = '<p>No Redis Cache or Session Servers have been created yet</p>';
            $dat[1]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_footer();
    }
    else {

        $tbl = jrCore_db_table_name('jrRedis', 'server');
        $req = "SELECT * FROM {$tbl} ORDER BY server_host ASC";
        $_rt = jrCore_db_query($req, 'NUMERIC');

        $dat             = array();
        $dat[1]['title'] = 'host / IP';
        $dat[1]['width'] = '52%';
        $dat[2]['title'] = 'port';
        $dat[2]['width'] = '11%';
        $dat[3]['title'] = 'cache';
        $dat[3]['width'] = '11%';
        $dat[4]['title'] = 'session';
        $dat[4]['width'] = '11%';
        $dat[5]['title'] = 'stats';
        $dat[5]['width'] = '5%';
        $dat[6]['title'] = 'modify';
        $dat[6]['width'] = '5%';
        $dat[7]['title'] = 'delete';
        $dat[7]['width'] = '5%';
        jrCore_page_table_header($dat);

        if ($_rt && is_array($_rt)) {
            foreach ($_rt as $k => $_server) {
                $dat             = array();
                $dat[1]['title'] = '<h3>' . $_server['server_host'] . '</h3>';
                $dat[1]['class'] = 'center';
                $dat[2]['title'] = $_server['server_port'];
                $dat[2]['class'] = 'center';
                $dat[3]['title'] = ($_server['server_cache'] == 'on') ? $pass : $fail;
                $dat[3]['class'] = 'center';
                $dat[4]['title'] = ($_server['server_session'] == 'on') ? $pass : $fail;
                $dat[4]['class'] = 'center';
                $dat[5]['title'] = jrCore_page_button("rinfo-{$k}", 'stats', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/server_info/id={$_server['server_id']}')");
                $dat[6]['title'] = jrCore_page_button("rmodify-{$k}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/server_update/id={$_server['server_id']}')");
                $dat[7]['title'] = jrCore_page_button("rdelete-{$k}", 'delete', "jrCore_confirm('Delete this Server?','Are you sure you want to delete this server?',function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/server_delete_save/id={$_server['server_id']}') })");
                jrCore_page_table_row($dat);
            }
        }
        else {
            $dat             = array();
            $dat[1]['title'] = '<p>No Redis Cache or Session Servers have been created yet - create a new one below</p>';
            $dat[1]['class'] = 'center';
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_footer();

        jrCore_page_section_header('add a new Redis server');
        jrCore_get_form_notice();

        // Form init
        $_tmp = array(
            'submit_value'     => 'create server',
            'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
            'form_ajax_submit' => false
        );
        jrCore_form_create($_tmp);

        // Server Host
        $_tmp = array(
            'name'     => 'server_host',
            'label'    => 'hostname / IP address',
            'help'     => 'Enter the IP Address or Host for this server',
            'type'     => 'text',
            'validate' => 'printable',
            'required' => true
        );
        jrCore_form_field_create($_tmp);

        // Server Port
        $_tmp = array(
            'name'     => 'server_port',
            'label'    => 'port',
            'help'     => 'Enter the port the Redis server is running on',
            'type'     => 'text',
            'validate' => 'number_nz',
            'default'  => 6379,
            'required' => true
        );
        jrCore_form_field_create($_tmp);

        // Server Password
        $_tmp = array(
            'name'     => 'server_pass',
            'label'    => 'password',
            'sublabel' => '(recommended)',
            'help'     => 'Enter the password that is used to connect to this Redis Server',
            'type'     => 'password',
            'validate' => 'not_empty',
            'required' => false
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();
}
