<?php
 /**
 * Jamroom Redis Cache module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: server_info
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrRedis_server_info($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrRedis', 'server_info');

    // Do we have multiple servers?
    $sel = '';
    $_tm = false;
    $_jm = array();
    if ($_cf = jrRedis_get_config()) {
        foreach ($_cf as $_servers) {
            foreach ($_servers as $sid => $_inf) {
                if (jrCore_module_is_active('jrCloudClient')) {
                    $_jm[$sid] = jrCloudClient_get_server_name_for_server($_inf[0]);
                }
                else {
                    $_jm[$sid] = $_inf[0];
                }
                if (!isset($_post['id'])) {
                    $_post['id'] = $sid;
                }
                if (!$_tm && $sid == $_post['id']) {
                    $_tm = $_inf;
                }
            }
        }
    }
    if (!$_tm) {
        jrCore_notice_page('error', 'unable to load any Redis Servers - check server config');
    }
    if (count($_jm) > 1) {
        // Setup Jumper
        $sel = '<select name="server_jumper" class="form_select form_select_item_jumper" onchange="jrCore_window_location(\'' . $_conf['jrCore_base_url'] . "/{$_post['module_url']}/server_info/id='+ $(this).val())\">\n";
        foreach ($_jm as $sid => $server) {
            if ($_post['id'] == $sid) {
                $sel .= '<option value="' . $sid . '" selected="selected"> ' . $server . "</option>\n";
            }
            else {
                $sel .= '<option value="' . $sid . '"> ' . $server . "</option>\n";
            }
        }
        $sel .= '</select>';
    }
    $sel .= jrCore_page_icon_button('refresh', 'refresh', "location.reload();");
    jrCore_page_banner('Redis Server Stats', $sel);

    $_rt = false;
    $rds = new Redis();
    jrRedis_start_timer('connect');
    try {
        $rds->connect($_tm[0], $_tm[1], $_conf['jrRedis_timeout']);
        if (!empty($_tm[3])) {
            $rds->auth($_tm[3]);
        }
        $rds->select(0);
        $_rt = $rds->info();
        $rds->close();
    }
    catch (Exception $e) {
        jrCore_page_notice('error', $e->getMessage());
    }

    $dat             = array();
    $dat[1]['title'] = 'memory';
    $dat[1]['width'] = '25%';
    $dat[2]['title'] = 'connections';
    $dat[2]['width'] = '25%';
    $dat[3]['title'] = 'keys';
    $dat[3]['width'] = '25%';
    $dat[4]['title'] = 'hits';
    $dat[4]['width'] = '25%';
    jrCore_page_table_header($dat);

    // How much memory are we using?
    if ($_rt && is_array($_rt)) {

        $_db = array();
        $_mp = jrCore_get_flag('jrredis_db_map');
        foreach ($_mp as $i => $d) {
            $_db["{$d[1]}"] = $i;
        }
        $_ks = array();
        $t_k = 0;
        $e_k = 0;
        foreach ($_rt as $k => $v) {
            // [db1] => keys=21,expires=1,avg_ttl=21580446
            if (strpos($k, 'db') === 0) {
                list($keys, $exps,) = explode(',', $v, 3);
                $keys         = (int) str_replace('keys=', '', $keys);
                $exps         = (int) str_replace('expires=', '', $exps);
                $db_num       = (int) str_replace('db', '', $k);
                $_ks[$db_num] = array($keys, $exps);
                $t_k          += $keys;
                $e_k          += $exps;
            }
        }

        $dat = array();
        $cls = 'bigsystem-inf bigsystem-smaller';
        if (!empty($_rt['maxmemory'])) {
            $perc = round((($_rt['used_memory'] / $_rt['maxmemory']) * 100), 1);
            if (isset($_rt['maxmemory_human'])) {
                $dat[1]['title'] = $_rt['used_memory_human'] . '<span>of ' . $_rt['maxmemory_human'] . ' </span>';
                if ($perc > 90) {
                    $cls = 'bigsystem-cri';
                }
                else {
                    if ($perc > 80) {
                        $cls = 'bigsystem-maj';
                    }
                }
            }
        }
        else {
            $dat[1]['title'] = $_rt['used_memory_human'] . '<span>peak: ' . $_rt['used_memory_peak_human'] . ' </span>';
        }
        $dat[1]['class'] = "bignum bignum1 {$cls}";
        $dat[2]['title'] = jrCore_number_format($_rt['connected_clients']) . '<span>total: ' . jrCore_number_format($_rt['total_connections_received']) . ' </span>';
        $dat[2]['class'] = 'bignum bignum2 bigsystem-smaller';
        $dat[3]['title'] = jrCore_number_format($t_k) . '<span>expiring: ' . jrCore_number_format($e_k) . '</span>';
        $dat[3]['class'] = 'bignum bignum3 bigsystem-smaller';
        if ($_rt['keyspace_hits'] > 0) {
            $dat[4]['title'] = round(($_rt['keyspace_hits'] / ($_rt['keyspace_hits'] + $_rt['keyspace_misses'])) * 100, 1) . '%<span>' . jrCore_number_format($_rt['keyspace_hits']) . ' hits </span>';
        }
        else {
            $dat[4]['title'] = '0' . '<span>0 hits</span>';
        }
        $dat[4]['class'] = 'bignum bignum4 bigsystem-smaller';
        jrCore_page_table_row($dat);
        jrCore_page_table_footer();

        // Key spaces first
        $dat             = array();
        $dat[1]['title'] = 'Database';
        $dat[1]['width'] = '30%';
        $dat[2]['title'] = 'Keys / Expiring';
        $dat[2]['width'] = '70%';
        jrCore_page_table_header($dat);

        foreach ($_ks as $db_num => $v) {
            // [db1] => keys=21,expires=1,avg_ttl=21580446
            $id              = str_pad($db_num, 2, '0', STR_PAD_LEFT);
            $dat[1]['title'] = (!empty($_db[$db_num])) ? "({$id}) {$_db[$db_num]}" : "({$id}) -";
            $dat[2]['title'] = "{$v[0]} / {$v[1]}";
            jrCore_page_table_row($dat);
        }

        $dat             = array();
        $dat[1]['title'] = 'Info Key';
        $dat[1]['width'] = '30%';
        $dat[2]['title'] = 'Value';
        $dat[2]['width'] = '70%';
        jrCore_page_table_header($dat, null, true);

        foreach ($_rt as $k => $v) {
            $dat             = array();
            $dat[1]['title'] = $k;
            $dat[2]['title'] = $v;
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_footer();

    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'Unable to retrieve stats from Redis Server';
        $dat[1]['class'] = 'p10 error center';
        jrCore_page_table_row($dat);
    }

    $_css = array(".bigsystem-smaller { font-size: 36px !important; line-height: 36px }");
    jrCore_create_page_element('css_embed', $_css);

    jrCore_page_table_footer();
    jrCore_page_display();
}
