<?php
 /**
 * Jamroom Redis Cache module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: server_update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrRedis_server_update_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid server id');
        jrCore_form_result();
    }
    $_ap = jrRedis_get_server_by_id($_post['id']);
    if (!$_ap || !is_array($_ap)) {
        jrCore_set_form_notice('error', 'invalid server id');
        jrCore_form_result();
    }

    $sid = (int) $_post['id'];
    $hst = jrCore_db_escape($_post['server_host']);
    $prt = (int) $_post['server_port'];
    $pas = jrCore_db_escape($_post['server_pass']);
    $csv = $_post['server_cache'];
    $ssv = $_post['server_session'];
    $tbl = jrCore_db_table_name('jrRedis', 'server');
    $req = "UPDATE {$tbl} SET server_host = '{$hst}', server_port = {$prt}, server_pass = '{$pas}', server_cache = '{$csv}', server_session = '{$ssv}' WHERE server_id = {$sid}";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {
        jrRedis_update_redis_config();
        jrCore_set_form_notice('success', 'The server was successfully updated');
        jrCore_form_delete_session();
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered updating the server - please try again');
    }
    jrCore_form_result();
}
