<?php
 /**
 * Jamroom Javascript Event Logger module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

/**
 * Log a Javascript event from the client
 * @param array $_post
 * @param array $_user
 * @param array $_conf
 */
function view_jrScriptLogger_event($_post, $_user, $_conf)
{
    // Allow max 1 log message every 5 seconds from IP
    $log = false;
    if ($uip = jrCore_get_ip()) {
        $pfx = jrCore_local_cache_get_key_prefix(true);
        $key = "{$pfx}:e:{$uip}";
        if ($tmp = apcu_fetch($key)) {
            if ($tmp <= time()) {
                apcu_delete($key);
            }
        }
        if (apcu_add($key, (time() + 5), 5)) {
            $log = true;
        }
    }
    if ($log) {
        if (!empty($_post['message'])) {
            $_data = array(
                'message' => trim(jrCore_strip_html($_post['message'])),
                '_uri'    => (!empty($_post['uri'])) ? $_post['uri'] : '',
                'agent'   => $_SERVER['HTTP_USER_AGENT'],
                'stack'   => (!empty($_post['stack'])) ? $_post['stack'] : ''
            );
            jrCore_run_module_function('jrCloudClient_record_event', 'jrScriptLogger', 'error');
            jrCore_logger('MAJ', "event: {$_data['message']}", $_data);
        }
    }
    jrCore_json_response(array('ok' => 1));
}
