<?php
 /**
 * Jamroom Search module
 *
 * copyright 2022 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: rebuild_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrSearch_rebuild_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Start clean
    $tbl = jrCore_db_table_name('jrSearch', 'fulltext');
    jrCore_db_query("TRUNCATE TABLE {$tbl}");

    $_md = jrCore_get_datastore_modules();
    if ($_md && is_array($_md)) {
        foreach ($_md as $mod => $pfx) {
            if (jrCore_module_is_active($mod) && !jrSearch_is_excluded_module($mod)) {

                $action = 'create';
                if (jrSearch_is_disabled_module($mod)) {

                    // This module has purposefully been disabled - delete from indexes
                    $action = 'delete';
                }

                elseif (jrSearch_module_has_dedicated_index($mod)) {

                    // Make sure index table exists
                    jrSearch_create_index_table_for_module($mod);

                    // Make sure it is clean
                    $tbl = jrCore_db_table_name('jrSearch', "fulltext_{$mod}");
                    jrCore_db_query("TRUNCATE TABLE {$tbl}");
                }

                // Create worker queue entry
                $_queue = array(
                    'action' => $action,
                    'module' => $mod
                );
                jrCore_queue_create('jrSearch', 'search_index', $_queue);
            }
        }
    }
    jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/global");
}
