<?php
/**
 * Jamroom ShareThis module
 *
 * copyright 2019 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * meta
 */
function jrShareThis_meta()
{
    $_tmp = array(
        'name'        => 'ShareThis',
        'url'         => 'sharethis',
        'version'     => '2.0.1',
        'developer'   => 'The Jamroom Network, &copy;' . strftime('%Y'),
        'description' => 'Adds ShareThis social media sharing to item pages (free account required)',
        'doc_url'     => 'https://www.jamroom.net/the-jamroom-network/documentation/modules/2598/sharethis',
        'category'    => 'item features',
        'requires'    => 'jrCore:6.0.5,jrMeta',
        'priority'    => 250,
        'license'     => 'jcl'
    );
    return $_tmp;
}

/**
 * init
 */
function jrShareThis_init()
{
    // We offer an Item Detail feature for SHARING buttons
    $_tmp = array(
        'function' => 'jrShareThis_share_feature',
        'label'    => 'Share Buttons',
        'help'     => 'Adds a &quot;Social Network sharing buttons&quot; section to Item Detail pages'
    );
    jrCore_register_module_feature('jrCore', 'item_detail_feature', 'jrShareThis', 'sharethis', $_tmp);

    // We also offer an Item Detail feature for REACTION buttons
    $_tmp = array(
        'function' => 'jrShareThis_reaction_feature',
        'label'    => 'Reactions',
        'help'     => 'Adds a &quot;Reactions&quot; section to Item Detail pages'
    );
    jrCore_register_module_feature('jrCore', 'item_detail_feature', 'jrShareThis', 'reactions', $_tmp);

    // Allow enable/disable per quota
    jrCore_register_module_feature('jrCore', 'quota_support', 'jrShareThis', 'on');
    jrCore_register_module_feature('jrCore', 'javascript', 'jrShareThis', true);

    // ShareThis widgets
    jrCore_register_module_feature('jrSiteBuilder', 'widget', 'jrShareThis', 'widget_share', 'Share Buttons');

    jrCore_register_event_listener('jrCore', 'view_results', 'jrShareThis_view_results_listener');
    return true;
}

//------------------------
// WIDGETS
//------------------------

/**
 * Create a Sharing Widget
 * @param $_post array Post info
 * @param $_user array User array
 * @param $_conf array Global Config
 * @param $_wg array Widget info
 * @return bool
 */
function jrShareThis_widget_share_config($_post, $_user, $_conf, $_wg)
{
    // Share
    $_tmp = array(
        'name'     => 'share_enabled',
        'label'    => 'Enable Share Buttons',
        'help'     => 'Check this option to show Share Buttons in the widget',
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // React
    $_tmp = array(
        'name'     => 'react_enabled',
        'label'    => 'Enable Reaction Buttons',
        'help'     => 'Check this option to show Reaction Buttons in the widget',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Follow
    $_tmp = array(
        'name'     => 'follow_enabled',
        'label'    => 'Enable Follow Buttons',
        'help'     => 'Check this option to show Follow Us Buttons in the widget',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);
    return true;
}

/**
 * Get Widget config data
 * @param $_post array Post info
 * @return array
 */
function jrShareThis_widget_share_config_save($_post)
{
    return array(
        'share_enabled'  => $_post['share_enabled'],
        'react_enabled'  => $_post['react_enabled'],
        'follow_enabled' => $_post['follow_enabled']
    );
}

/**
 * HTML Editor Widget DISPLAY
 * @param $_widget array Page Widget info
 * @return string
 */
function jrShareThis_widget_share_display($_widget)
{
    return jrCore_parse_template('widget.tpl', $_widget, 'jrShareThis');
}

//------------------------
// EVENT LISTENERS
//------------------------

/**
 * Add ShareThis javascript
 * @param $_data string incoming data
 * @param $_user array current user info
 * @param $_conf array Global config
 * @param $_args array additional info about the module
 * @param $event string Event Trigger name
 * @return string
 */
function jrShareThis_view_results_listener($_data, $_user, $_conf, $_args, $event)
{
    if (!empty($_conf['jrShareThis_pub_key'])) {
        if (strpos($_data, '</head>')) {
            $prod = 'sop';
            if (!strpos($_data, 'sharethis-inline-share-button')) {
                $prod = 'custom-share-buttons';
            }
            $html  = '<script type="text/javascript" src="//platform-api.sharethis.com/js/sharethis.js#property=' . $_conf['jrShareThis_pub_key'] . '&amp;product=' . $prod . '" async="async"></script>';
            $_data = str_replace('</head>', $html . "\n</head>", $_data);
        }
    }
    return $_data;
}

//------------------------
// FUNCTIONS
//------------------------

/**
 * Add a ShareThis section to item detail pages
 * @param string $module Module item belongs to
 * @param array $_item Item info (from DS)
 * @param array $params Smarty function parameters
 * @param array $smarty current Smarty object
 * @return string
 */
function jrShareThis_share_feature($module, $_item, $params, $smarty)
{
    global $_conf, $_post;
    // Must have a valid Property ID
    if (!isset($_conf['jrShareThis_pub_key']) || strlen($_conf['jrShareThis_pub_key']) === 0) {
        return '';
    }
    // See if we are enabled in this quota
    if (isset($_item['quota_jrShareThis_show_detail']) && $_item['quota_jrShareThis_show_detail'] == 'off') {
        return '';
    }
    $out = jrCore_parse_template('buttons.tpl', $_post, 'jrShareThis');
    if (!empty($params['assign'])) {
        /** @noinspection PhpUndefinedMethodInspection */
        $smarty->assign($params['assign'], $out);
        return '';
    }
    return $out;
}

/**
 * Add a Reactions section to item detail pages
 * @param string $module Module item belongs to
 * @param array $_item Item info (from DS)
 * @param array $params Smarty function parameters
 * @param array $smarty current Smarty object
 * @return string
 */
function jrShareThis_reaction_feature($module, $_item, $params, $smarty)
{
    global $_conf, $_post;
    // Must have a valid Property ID
    if (!isset($_conf['jrShareThis_pub_key']) || strlen($_conf['jrShareThis_pub_key']) === 0) {
        return '';
    }
    // See if we are enabled in this quota
    if (isset($_item['quota_jrShareThis_show_reaction']) && $_item['quota_jrShareThis_show_reaction'] == 'off') {
        return '';
    }
    $out = jrCore_parse_template('reactions.tpl', $_post, 'jrShareThis');
    if (!empty($params['assign'])) {
        /** @noinspection PhpUndefinedMethodInspection */
        $smarty->assign($params['assign'], $out);
        return '';
    }
    return $out;
}

//------------------------
// SMARTY
//------------------------

/**
 * ShareThis smarty template function
 * @param array $params Smarty function parameters
 * @param array $smarty current Smarty object
 * @return string
 */
function smarty_function_jrShareThis($params, $smarty)
{
    if (!isset($params['module'])) {
        return jrCore_smarty_missing_error('module');
    }
    $_it = array();
    if (isset($params['item_id'])) {
        if (!jrCore_checktype($params['item_id'], 'number_nz')) {
            return jrCore_smarty_invalid_error('item_id');
        }
        $_it = jrCore_db_get_item($params['module'], $params['item_id']);
        if (!$_it) {
            return '';
        }
    }
    $out = jrShareThis_share_feature($params['module'], $_it, $params, $smarty);
    if (!empty($params['assign'])) {
        /** @noinspection PhpUndefinedMethodInspection */
        $smarty->assign($params['assign'], $out);
        return '';
    }
    return $out;
}
