<?php
 /**
 * Jamroom Support Center module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: options
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrSupport_options($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    if (!isset($_post['_2'])) {
        $_rs = array('error' => 'Invalid module or skin - please try again');
        jrCore_json_response($_rs);
    }
    $item = $_post['_2'];
    switch ($_post['_1']) {
        case 'module':
            if (!isset($_mods[$item])) {
                $_rs = array('error' => 'Invalid module - does not seem to be active in the system');
                jrCore_json_response($_rs);
            }
            break;
        case 'skin':
            $_skins = jrCore_get_skins();
            if (!isset($_skins[$item])) {
                $_rs = array('error' => 'Invalid skin - does not seem to be active in the system');
                jrCore_json_response($_rs);
            }
            break;
        default:
            $_rs = array('error' => 'Invalid item type - please try again');
            jrCore_json_response($_rs);
            break;
    }

    // Send off request
    if (isset($_conf['jrSupport_support_email']) && strpos($_conf['jrSupport_support_email'], '@')) {
        $_dt = array(
            'email' => (isset($_conf['jrSupport_support_email'])) ? jrCore_url_encode_string($_conf['jrSupport_support_email']) : 'null',
            'type'  => $_post['_1'],
            'item'  => $item
        );
        // Are we on a different active system?
        $url = 'https://www.jamroom.net';
        if (jrCore_module_is_active('jrMarket')) {
            $_mkt = jrMarket_get_active_release_system();
            if ($_mkt && is_array($_mkt) && isset($_mkt['system_url']) && jrCore_checktype($_mkt['system_url'], 'url')) {
                $url = $_mkt['system_url'];
            }
        }
        $_rs = jrCore_load_url("{$url}/networksupport/options", $_dt, 'POST');
        if ($_rs && strpos($_rs, '{') === 0) {
            $_rs = json_decode($_rs, true);
            return jrCore_parse_template('options.tpl', $_rs, 'jrSupport');
        }
        return '<div class="p10 error">error communicating with support server - check Support URL</div>';
    }
    $_rs = array('error' => "Make sure you have entered your Email Address in <a href=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/global\"><u>Global Config</u></a> to see all support options available.");
    return jrCore_parse_template('options.tpl', $_rs, 'jrSupport');

}
