// Jamroom Tags Module Javascript
// @copyright 2003-2013 by Talldude Networks LLC
// @author Michael Ussher - michael@jamroom.net

/**
 * Add a new tag
 * @param {string} f Form ID
 */
function jrTags_create_tag(f)
{
    $(f + ' #tag_submit').attr('disabled', 'disabled').addClass('form_button_disabled');
    $(f + ' #tag_submit_indicator').show(300, function() {
        setTimeout(function() {
            var u = core_system_url + '/' + jrTags_url + '/tag_save';
            jrCore_set_csrf_cookie(u);
            $.post(u, $('#tag_form').serialize(), function(r) {
                $(f + ' #tag_submit_indicator').hide(300, function() {
                    $(f + ' #tag_submit').jrCore_enable_button();
                    if (typeof r.error !== "undefined") {
                        $('#tag_message').removeClass('success').addClass('error').text(r.error).fadeIn();
                    }
                    else {
                        $('#tag_message').hide();
                        $('#tag_text').val('');
                        jrTags_load(r.tag_module, r.tag_item_id);
                    }
                });
            });
        }, 300);
    });
}

/**
 * Load existing tags for an item
 * @param m string module
 * @param i int item_id
 * @param b string a base url to append the tag to if different from default.
 */
function jrTags_load(m, i, b)
{
    var u = core_system_url + '/' + jrTags_url + '/existing_tags/tag_module=' + m + '/tag_item_id=' + Number(i)
    $.post(u, { tag_module: m, tag_item_id: Number(i), base_url: b }, function(r) {
        if (typeof r.error !== "undefined") {
            jrCore_alert(r.error);
        }
        else {
            $('#existing_tags').empty().html(r.html);
        }
    });
}

/**
 * Delete a tag by id
 * @param {number} id
 */
function jrTags_delete(i)
{
    var u = core_system_url + '/' + jrTags_url + '/tag_delete/id=' + Number(i);
    jrCore_set_csrf_cookie(u);
    $.post(u, function(r) {
        if (typeof r.error !== "undefined") {
            jrCore_alert(r.error);
        }
        else {
            $('#tag_' + i).fadeOut(250);
        }
    });
}

/**
 * @deprecated
 */
function jrLoadTags(m, i, p)
{
    return jrTags_load(m, i);
}

/**
 * @deprecated
 */
function jrTagsAdd(f)
{
    return jrTags_create_tag(f);
}

/**
 * @deprecated
 */
function jrDeleteTag(i)
{
    return jrTags_delete(i);
}