<?php
 /**
 * Jamroom Item Tags module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: tag_delete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrTags_tag_delete($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        return jrCore_json_response(array('error' => 'invalid tag id'));
    }
    $tid = (int) $_post['id'];
    if (!$_tg = jrTags_get_tag_by_tag_id($tid)) {
        return jrCore_json_response(array('error' => 'invalid tag id - data not found'));
    }
    if (!jrUser_is_admin()) {
        if (!jrProfile_is_profile_owner($_tg['tag_profile_id']) && $_user['_user_id'] != $_tg['tag_user_id']) {
            jrUser_not_authorized();
        }
    }
    if (jrTags_delete_tag_by_tag_id($tid)) {
        jrTags_delete_tag_from_item_data($_tg['tag_module'], $_tg['tag_profile_id'], $_tg['tag_item_id'], $_tg['tag_value']);
        jrUser_reset_cache($_user['_user_id'], $_tg['tag_module']);
        jrProfile_reset_cache($_tg['tag_profile_id'], $_tg['tag_module']);
        $_ln = jrUser_load_lang_strings();
        return jrCore_json_response(array('success' => $_ln['jrTags'][15]));
    }
    return jrCore_json_response(array('error' => 'error deleting tag from database'));
}
