<?php
 /**
 * Jamroom Media URL Scanner module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * config
 */
function jrUrlScan_config()
{
    // Immediate Replace
    $_tmp = array(
        'name'     => 'immediate_replace',
        'default'  => 'on',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'label'    => 'Expanded Media',
        'help'     => 'If this is checked embedded media will be &quot;expanded&quot; by default and show on the page - the user will not have to click the media title. If this is unchecked, the user must click on the media title to expand and show the media.',
        'order'    => 1
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // Strip Tracking Parameters
    $_tmp = array(
        'name'     => 'strip_tracking',
        'default'  => 'on',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'label'    => 'Remove Tracking Params',
        'help'     => 'If this option is checked saved URLs will be stripped of common tracking and sharing parameters such as &quot;fbclid&quot;, &quot;utm_source&quot;, etc.',
        'order'    => 2
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // Set button height
    $_sz  = array(
        '0'  => 'Disabled',
        '8'  => '8px',
        '10' => '10px',
        '12' => '12px',
        '14' => '14px',
        '16' => '16px',
        '18' => '18px',
        '20' => '20px',
        '24' => '24px',
        '28' => '28px',
        '32' => '32px',
        '36' => '36px',
        '40' => '40px',
        '48' => '48px',
        '56' => '56px',
        '64' => '64px',
    );
    $_tmp = array(
        'name'     => 'play_button_size',
        'type'     => 'select',
        'default'  => '0',
        'options'  => $_sz,
        'validate' => 'printable',
        'label'    => 'Play Button Size',
        'help'     => 'Select the play button size in pixels',
        'order'    => 3
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // Daily Maintenance
    $_tmp = array(
        'name'     => 'daily_maintenance',
        'default'  => 0,
        'type'     => 'text',
        'validate' => 'number_nn',
        'required' => 'on',
        'label'    => 'Daily URL Checks',
        'help'     => 'Enter the number of URLs that should be checked on a daily basis. Every hour during hourly maintenance, 1/24th of the value entered here will be validated.  You can disable maintenance by entering a 0 (zero) for this value.',
        'order'    => 4
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // OpenGraph enable
    $_tmp = array(
        'primary'  => 'Primary - for all URL Cards',
        'fallback' => 'Fallback - only if local URL Card fails',
        'disabled' => 'Disabled'
    );
    $_tmp = array(
        'name'     => 'opengraph_enabled',
        'type'     => 'select',
        'options'  => $_tmp,
        'default'  => 'disabled',
        'validate' => 'not_empty',
        'label'    => 'OpenGraph API Mode',
        'help'     => 'Select how you would like to work with the OpenGraph API:<br><br><b>Primary:</b> The OpenGraph API service will be used to generate all URL Cards.<br><br><b>FallBack:</b> The OpenGraph API will be used only if the initial call to the site using wget fails.',
        'required' => false,
        'section'  => 'Opengraph',
        'order'    => 10
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // OpenGraph.io API key
    $_tmp = array(
        'name'     => 'opengraph_api_key',
        'type'     => 'text',
        'default'  => '',
        'validate' => 'printable',
        'label'    => 'OpenGraph API Key',
        'help'     => 'Enter your OpenGraph.io API key',
        'required' => false,
        'section'  => 'Opengraph',
        'order'    => 11
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // Google Safe Browsing
    $_tmp = array(
        'name'     => 'safe_urls',
        'default'  => 'off',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'label'    => 'Enable Safe Browsing',
        'help'     => 'If this option is checked, URLs will be checked with the Google Safe Browsing service to ensure the URL does not link to Malware or other online threats.<br><br>If a URL is reported as being unsafe by Google Safe Browsing, it will be removed from the content and an entry will be recorded to the Activity Log.',
        'section'  => 'safe browsing',
        'order'    => 21
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // API Key
    $_tmp = array(
        'name'     => 'api_key',
        'type'     => 'text',
        'default'  => '',
        'validate' => 'printable',
        'label'    => 'Safe Browsing API Key',
        'help'     => 'Enter your Safe Browsing API Key that was created for you in the Google Developer Console',
        'required' => false,
        'section'  => 'safe browsing',
        'order'    => 22
    );
    jrCore_register_setting('jrUrlScan', $_tmp);

    // Old settings
    jrCore_delete_setting('jrUrlScan', 'soundcloud_client_id');
    jrCore_delete_setting('jrUrlScan', 'flickr_key');

    return true;
}

/**
 * Advanced Config keys
 */
function jrUrlScan_advanced_config()
{
    jrCore_register_advanced_config_key('jrUrlScan', 'user_agent', false, "Enter the User Agent that will be used when downloading and parsing HTML to create a URL card");
    return true;
}
