<?php
 /**
 * Jamroom Media URL Scanner module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * URL card tests
 */
function test_jrUrlScan_cards()
{
    $_urls = array();

    // Extract OG Tags from a remote site
    $_urls[] = 'https://www.linode.com/press-release/akamai-to-acquire-linode/';
    $_urls[] = 'https://www.nbcnews.com/news/variants-omicron-develop-makes-variants-concern-rcna6798';
    $_urls[] = 'https://facebook.com/events/s/animal-trivia-and-pint-night-f/2702259549891222/?ti=as';
    $_urls[] = 'https://www.eventbrite.com/e/mutts-mimosas-tickets-90718693053?aff=ebdssbdestsearch';
    $_urls[] = 'https://www.washingtonpost.com/science/2020/08/13/dogs-walking-coronavirus/?hpid=hp_hp-banner-main_dogs-12pm:homepage/story-ans';

    foreach ($_urls as $url) {
        $name = substr(rtrim(trim(str_replace(array('http://', 'https://'), '', $url)), '/'), 0, 70);
        jrUnitTest_init_test($name);
        $_tags = jrUrlScan_extract_tags_from_url($url, null, true);
        if (empty($_tags['og:title'])) {
            jrUnitTest_exit_with_error();
        }
    }

    // These URLs do not contain HTML and should not be parsable
    /*
    $_bad = array();
    $_bad[] = 'https://c13.radioboss.fm/stream/93';

    foreach ($_bad as $url) {
        $name = substr(rtrim(trim(str_replace(array('http://', 'https://'), '', $url)), '/'), 0, 70);
        jrUnitTest_init_test($name);
        $_tags = jrUrlScan_extract_tags_from_url($url, null, true);
        if ($_tags || isset($_tags['og:title'])) {
            jrUnitTest_exit_with_error();
        }
    }
    */

}
