<?php
 /**
 * Jamroom Media URL Scanner module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browser
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUrlScan_browser($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrUrlScan');
    jrCore_page_banner('URL Card Browser');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'card';
    $dat[2]['title'] = 'refresh';
    $dat[2]['width'] = '5%';
    $dat[3]['title'] = 'delete';
    $dat[3]['width'] = '5%';
    jrCore_page_table_header($dat);

    $_sp = array(
        'search'          => array(
            "_item_id > 0",
        ),
        'skip_all_checks' => true,
        'pagebreak'       => jrCore_get_pager_rows(),
        'page'            => 1
    );
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $_sp['page'] = (int) $_post['p'];
    }
    $_rt = jrCore_db_search_items('jrUrlScan', $_sp);
    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        foreach ($_rt['_items'] as $_i) {
            $dat = array();
            if (empty($_i['urlscan_ogtitle']) && !empty($_i['urlscan_title'])) {
                $_i['urlscan_ogtitle'] = $_i['urlscan_title'];
            }
            $card            = jrCore_parse_template('url_card.tpl', array('item' => $_i), 'jrUrlScan');
            $dat[1]['title'] = $card;
            $dat[2]['title'] = jrCore_page_button("refresh-tag-{$_i['_item_id']}", 'refresh', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/refresh/id={$_i['_item_id']}')");
            $dat[3]['title'] = jrCore_page_button("delete-tag-{$_i['_item_id']}", 'delete', "jrCore_confirm('', 'Are you sure you want to delete this card?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_save/id={$_i['_item_id']}') } )");
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = "<p>no media urls exist yet - create one by adding a link in a timeline post.</p>";
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_pager($_rt);
    jrCore_page_table_footer();

    jrCore_page_display();
}
