<?php
 /**
 * Jamroom Media URL Scanner module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: parse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUrlScan_parse($_post, $_user, $_conf)
{
    if (!isset($_post['_4']) || !jrCore_module_is_active($_post['_4'])) {
        return 'invalid module';
    }
    if (!is_file("{$_conf['jrCore_base_dir']}/modules/{$_post['_4']}/templates/{$_post['_1']}.tpl")) {
        return 'invalid template';
    }
    $rep = jrCore_get_config_value('jrUrlScan', 'immediate_replace', 'on');
    $key = json_encode($_post) . $rep;
    if (!$out = jrCore_is_cached('jrUrlScan', $key, false, false, true, false)) {
        $_rp = array(
            'template'        => $_post['_1'],
            '_item_id'        => (int) $_post['_2'],
            'remote_media_id' => $_post['_3'],
            'module'          => $_post['_4'],
            'autoplay'        => ($rep == 'on') ? false : true,
            'autoplay_int'    => ($rep == 'on') ? 0 : 1
        );
        // Give our module a chance to add things in
        $_rp = jrCore_trigger_event('jrUrlScan', 'url_player_params', $_rp, $_post, $_post['_4']);
        $out = jrCore_parse_template("{$_post['_1']}.tpl", $_rp, $_post['_4']);
        jrCore_add_to_cache('jrUrlScan', $key, $out, 0, 0, false, false, false);
    }
    return $out;
}
