// Jamroom User Module Admin Javascript
// @copyright 2003-2018 by Talldude Networks LLC

/**
 * Show delete user modal
 * @param u number User ID
 * @param p number Profile ID
 */
function jrUser_delete_user(u, p)
{
    $('#user-delete-active-user-id').text(u);
    $('#user-delete-active-profile-id').text(p);
    if (Number(p) === 0) {
        $('#modal_window.user-delete-modal').find('#d-profile').addClass('form_button_disabled').attr('disabled', 'disabled');
    }
    else {
        $('#modal_window.user-delete-modal').find('#d-profile').removeClass('form_button_disabled').removeAttr('disabled');
    }
    $('#modal_window').modal();
}

/**
 * Delete a user
 */
function jrUser_delete_user_from_modal()
{
    $('#modal_window.user-delete-modal').find('input').addClass('form_button_disabled').attr('disabled', 'disabled');
    var i = $('#user-delete-active-user-id').text();
    var u = core_system_url + '/' + jrUser_url + '/delete_save/id=' + Number(i) + '/modal=1';
    jrCore_window_location(u);
}

/**
 * Delete a profile
 */
function jrUser_delete_profile_from_modal()
{
    $('#modal_window.user-delete-modal').find('input').addClass('form_button_disabled').attr('disabled', 'disabled');
    var i = $('#user-delete-active-profile-id').text();
    var u = core_system_url + '/' + jrProfile_url + '/delete_save/id=' + Number(i) + '/modal=1';
    jrCore_window_location(u);
}

/**
 * Ban a user IP and remove session
 * @param string ip
 */
function jrUser_ban_user_ip(ip)
{
    jrCore_confirm('Ban IP Address?', 'This will remove all sessions for this IP and ban the IP address', function() {
        var u = core_system_url + '/' + jrUser_url + '/ban_user_ip/ip=' + ip;
        jrCore_window_location(u);
    });
}