<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: account
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_account($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    $_lang = jrUser_load_lang_strings();

    // See if we are modifying a different account
    $pwl = true; // password lock if temp change is pending
    $frm = true;

    // Get user info for what has been requested
    $_data = jrUser_get_requested_user_account_info();
    if (!is_array($_data)) {
        $frm = false;
    }

    if (jrUser_is_admin()) {
        if (isset($_data['user_blocked']) && $_data['user_blocked'] == '1') {
            jrCore_set_form_notice('error', "This User Account is <b>blocked</b> - the user cannot log in to the site", false);
        }
    }

    jrUser_account_tabs('account', $_data);

    $button = '';
    if (!empty($_data['profile_name'])) {
        $button .= jrCore_page_button('account-tabs-profile-button', "@{$_data['profile_url']}", "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_data['profile_url']}')");
    }
    if (!jrUser_is_admin() && jrCore_get_config_value('jrUser', 'allow_delete', 'off') == 'on' && $_data['_user_id'] == $_user['_user_id']) {
        $delurl = jrCore_get_base_url() . "/{$_post['module_url']}/authenticate/delete=1";
        $button .= jrCore_page_button('account-tabs-delete-button', $_lang['jrUser'][134], "jrCore_window_location('{$delurl}')");
    }
    if (jrUser_is_admin() && $_user['_user_id'] != $_data['_user_id']) {
        $button .= jrCore_page_button('account-tabs-password-button', 'new password', "jrCore_confirm('Create New Password?','This will generate a new random password and notify the user via email', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/password_create_save/user_id={$_data['_user_id']}') })");
    }
    $uid = (int) $_data['_user_id'];
    $pid = (int) $_data['_profile_id'];
    if ($_data['_user_id'] != $_user['_user_id']) {
        $pwl = false;
    }

    if ($frm) {

        // We're showing our form
        // Form init
        $_tmp = array(
            'submit_value'     => $_lang['jrCore'][72],
            'cancel'           => 'reset_form_referrer',
            'values'           => $_data,
            'form_ajax_submit' => false
        );
        jrCore_form_create($_tmp);

        // See if this is a profile admin
        if (isset($_data)) {

            // User ID we are modifying
            $_tmp = array(
                'name'     => 'user_id',
                'type'     => 'hidden',
                'value'    => $uid,
                'validate' => 'number_nz'
            );
            jrCore_form_field_create($_tmp);

            // Profile ID we are modifying
            $_tmp = array(
                'name'     => 'profile_id',
                'type'     => 'hidden',
                'value'    => $pid,
                'validate' => 'number_nz'
            );
            if ($pid === 0) {
                $_tmp['validate'] = 'number_nn';
            }
            jrCore_form_field_create($_tmp);
        }
        else {
            $_data               = jrCore_db_get_item('jrUser', $_user['_user_id'], true); // OK
            $_post['user_id']    = $_user['_user_id'];
            $_post['profile_id'] = $_user['_profile_id'];
        }

        // Make sure we set error if no email address - this can happen using the social login
        if (!jrCore_checktype($_user['user_email'], 'email') && !isset($_SESSION['show_email_exists_error'])) {
            jrCore_set_form_notice('error', 68);
            jrCore_form_field_hilight('user_email');
        }
        if (isset($_SESSION['show_email_exists_error'])) {
            unset($_SESSION['show_email_exists_error']);
        }

        // our page banner
        jrCore_page_banner(42, $button, false);
        jrCore_get_form_notice();

        // User Jumper
        if (jrUser_is_admin() && isset($_post['profile_id']) && jrCore_checktype($_post['profile_id'], 'number_nz')) {

            // More than 1 user account associated with this profile?
            $pid = (int) $_post['profile_id'];
            $tbl = jrCore_db_table_name('jrProfile', 'profile_link');
            $req = "SELECT * FROM {$tbl} WHERE profile_id = {$pid}";
            $_xu = jrCore_db_query($req, 'user_id', false, 'profile_id');

            if (is_array($_xu) && count($_xu) > 1) {
                $_un = jrCore_db_get_multiple_items('jrUser', array_keys($_xu), array('_user_id', 'user_name'));
                if ($_un && is_array($_un) && count($_un) > 0) {
                    $html = '<select name="selected_user_id" class="form_select" onchange="jrCore_window_location(\'' . $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/account/profile_id=' . $pid . '/user_id=\'+ $(this).val());">' . "\n";
                    $ucnt = 0;
                    foreach ($_un as $v) {
                        if (strlen($v['user_name']) > 0) {
                            if ($v['_user_id'] == $_post['user_id']) {
                                $html .= '<option value="' . $v['_user_id'] . '" selected> ' . $v['user_name'] . '</option>';
                            }
                            else {
                                $html .= '<option value="' . $v['_user_id'] . '"> ' . $v['user_name'] . '</option>';
                            }
                            $ucnt++;
                        }
                    }
                    $html .= '</select><br>&nbsp;<small>There are <strong>' . $ucnt . ' User Accounts</strong> associated with this profile.</small>';
                    jrCore_page_custom($html, 'user account', 'select to make active');
                }
            }
        }

        // If we modifying FROM the Profile Browser, we redirect there on save...
        $ref = jrCore_get_local_referrer();
        if (jrUser_is_admin() && strpos($ref, '/browser')) {
            $_tmp = array(
                'name'  => 'from_browser',
                'type'  => 'hidden',
                'value' => $ref
            );
            jrCore_form_field_create($_tmp);
        }

        // User Avatar
        $_tmp = array(
            'name'         => 'user_image',
            'label'        => 53,
            'help'         => 93,
            'type'         => 'image',
            'size'         => 'medium',
            'image_delete' => true,
            'required'     => false
        );
        if (isset($_us) && is_array($_us)) {
            $_tmp['value'] = $_us;
        }
        jrCore_form_field_create($_tmp);

        // User Name
        $_tmp = array(
            'name'           => 'user_name',
            'label'          => 4,
            'help'           => 5,
            'type'           => 'text',
            'validate'       => 'printable',
            'autocapitalize' => 'off',
            'autocorrect'    => 'off',
            'required'       => true
        );
        if (!jrCore_is_mobile_device() && !jrCore_is_tablet_device()) {
            $_tmp['readonly'] = true;
            $_tmp['onfocus']  = "this.removeAttribute('readonly');";
        }
        jrCore_form_field_create($_tmp);

        // User Email
        $_tmp = array(
            'name'           => 'user_email',
            'label'          => 18,
            'help'           => 57,
            'type'           => 'text',
            'validate'       => 'email',
            'autocapitalize' => 'off',
            'autocorrect'    => 'off',
            'required'       => true
        );
        if (!jrCore_is_mobile_device() && !jrCore_is_tablet_device()) {
            $_tmp['readonly'] = true;
            $_tmp['onfocus']  = "this.removeAttribute('readonly');";
        }
        jrCore_form_field_create($_tmp);

        // Preferred Language
        $_lng = jrUser_get_languages();
        if ($_lng && is_array($_lng) && count($_lng) > 1) {
            $_tmp = array(
                'name'     => 'user_language',
                'label'    => 62,
                'help'     => 63,
                'type'     => 'select',
                'options'  => 'jrUser_get_languages',
                'required' => true
            );
            jrCore_form_field_create($_tmp);
        }

        // Password #1
        $_tmp = array(
            'name'     => 'user_passwd1',
            'label'    => 7,
            'help'     => 8,
            'type'     => 'password',
            'required' => false,
            'validate' => 'not_empty'
        );
        if ($pwl && isset($_user['user_temp_password'])) {
            $_tmp['required'] = true;
        }
        if (!jrCore_is_mobile_device() && !jrCore_is_tablet_device()) {
            $_tmp['readonly'] = true;
            $_tmp['onfocus']  = "this.removeAttribute('readonly');";
        }
        jrCore_form_field_create($_tmp);

        // Password #2
        $_tmp = array(
            'name'     => 'user_passwd2',
            'label'    => 32,
            'help'     => 23,
            'type'     => 'password',
            'required' => false,
            'validate' => 'not_empty',
        );
        if ($pwl && isset($_user['user_temp_password'])) {
            $_tmp['required'] = true;
        }
        if (!jrCore_is_mobile_device() && !jrCore_is_tablet_device()) {
            $_tmp['readonly'] = true;
            $_tmp['onfocus']  = "this.removeAttribute('readonly');";
        }
        jrCore_form_field_create($_tmp);

        $_tmp = jrCore_get_flag('jruser_register_setting');
        if ($_tmp) {
            foreach ($_tmp as $smod => $_entries) {
                // Make sure the viewing user has Quota access to this module
                if (isset($_user["quota_{$smod}_allowed"]) && $_user["quota_{$smod}_allowed"] != 'on') {
                    continue;
                }
                foreach ($_entries as $_field) {
                    // Language replacements...
                    if (isset($_field['label']) && jrCore_checktype($_field['label'], 'number_nz') && isset($_lang[$smod]["{$_field['label']}"])) {
                        $_field['label'] = $_lang[$smod]["{$_field['label']}"];
                    }
                    if (isset($_field['help']) && jrCore_checktype($_field['help'], 'number_nz') && isset($_lang[$smod]["{$_field['help']}"])) {
                        $_field['help'] = $_lang[$smod]["{$_field['help']}"];
                    }
                    if (isset($_field['error_msg']) && jrCore_checktype($_field['error_msg'], 'number_nz') && isset($_lang[$smod]["{$_field['error_msg']}"])) {
                        $_field['error_msg'] = $_lang[$smod]["{$_field['error_msg']}"];
                    }
                    jrCore_form_field_create($_field);
                }
            }
        }

        // Master Admin options
        if (jrUser_is_admin()) {

            // Blocked User - do not show if user is a master admin
            if ($_data['user_group'] !== 'master' || (isset($_data['user_blocked']) && $_data['user_blocked'] == 1)) {
                $_tmp = array(
                    'name'          => 'user_blocked',
                    'label'         => 'Block User',
                    'help'          => 'If this option is checked, this User Account will remain active but the user will be prevented from logging in',
                    'type'          => 'checkbox',
                    'validate'      => 'onoff',
                    'value'         => (isset($_data['user_blocked']) && $_data['user_blocked'] == 1) ? 'on' : 'off',
                    'section'       => 'admin options',
                    'form_designer' => false,
                    'order'         => 200
                );
                if ($_tmp['value'] == 'on') {
                    jrCore_form_field_hilight('user_blocked');
                }
                jrCore_form_field_create($_tmp);
            }

            if (jrUser_is_master()) {
                $_tmp = array(
                    'name'          => 'user_group',
                    'label'         => 'user group',
                    'help'          => 'Select the user group this user should be part of:<br><br><b>Standard User:</b> a normal user account in your system - can modify items they have created only.<br><b>Profile Admin:</b> can modify users and profiles and items created by any user on the system. Has access to the Dashboard.<br><b>Master Admin:</b> full access to all system areas including the Admin Control Panel and Dashboard.',
                    'type'          => 'select',
                    'options'       => array('user' => 'Standard User', 'admin' => 'Profile Admin', 'master' => 'Master Admin'),
                    'value'         => $_data['user_group'],
                    'group'         => 'master',
                    'validate'      => 'core_string',
                    'form_designer' => false,
                    'section'       => 'admin options',
                    'order'         => 250
                );
                // Don't let us change our own account
                if ($_data['_user_id'] == $_user['_user_id']) {
                    $_tmp['disabled'] = true;
                }
                jrCore_form_field_create($_tmp);

                // See if this user is linked to more than 1 profile
                $_lp = jrProfile_get_user_linked_profiles($_data['_user_id']);
                if ($_lp && is_array($_lp) && count($_lp) > 1) {

                    // looks like this user is linked to more than 1 profile
                    $_sc = array(
                        'search'         => array(
                            '_item_id in ' . $_data['_profile_id'] . ',' . implode(',', array_keys($_lp))
                        ),
                        'return_keys'    => array('_profile_id', 'profile_url', 'profile_name'),
                        'order_by'       => false,
                        'limit'          => (count($_lp) + 1),
                        'skip_triggers'  => true,
                        'ignore_pending' => true,
                        'privacy_check'  => false
                    );
                    $_tp = jrCore_db_search_items('jrProfile', $_sc);
                    if ($_tp && is_array($_tp) && isset($_tp['_items'])) {
                        $_pr = array();
                        foreach ($_tp['_items'] as $_v) {
                            $url = "{$_conf['jrCore_base_url']}/{$_v['profile_url']}";
                            if ($_data['_profile_id'] == $_v['_profile_id']) {
                                $_pr["{$_v['_profile_id']}"] = "<a href=\"{$url}\" target=\"_blank\">{$_v['profile_name']}</a> - <b>Home Profile</b>";
                            }
                            else {
                                $_pr["{$_v['_profile_id']}"] = "<a href=\"{$url}\" target=\"_blank\">{$_v['profile_name']}</a>";
                            }
                        }
                        natcasesort($_pr);
                        $_tmp = array(
                            'name'          => 'user_linked_profiles',
                            'label'         => 'linked profiles',
                            'help'          => "This User Account is linked to the listed Profiles. Uncheck a profile to prevent this user from accessing it.",
                            'type'          => 'optionlist',
                            'options'       => $_pr,
                            'value'         => array_keys($_lp),
                            'group'         => 'master',
                            'form_designer' => false,
                            'order'         => 251
                        );
                        jrCore_form_field_create($_tmp);
                    }
                }
            }
        }
    }
    jrCore_page_display();
}
