<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_language
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_create_language($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrUser');

    jrCore_set_form_notice('notice', 'Create or Update a User Language by cloning an existing language.');
    jrCore_page_banner('create or update a user language');

    // Form init
    $_tmp = array(
        'submit_value' => 'clone language strings',
        'cancel'       => 'referrer'
    );
    jrCore_form_create($_tmp);

    // Clone Language
    $_tmp = array(
        'name'     => 'new_lang_clone',
        'label'    => 'clone language',
        'help'     => 'Select the existing User Language you would like to clone - language strings that exist in the Cloned Language, but not in the New Language will be inserted.',
        'type'     => 'select',
        'options'  => 'jrUser_get_languages',
        'value'    => 'en-US',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // New Lang Code
    $_tmp = array(
        'name'     => 'new_lang_code',
        'label'    => 'language code',
        'sublabel' => '(click help for details)',
        'help'     => 'This should be the 2 digit ISO-639-1 Code for the language family, followed by a dash (-) and a 2 digit, uppercase local code - i.e. "en-US", "en-GB", etc. A list of 2 digit ISO-639-1 codes can be found in Wikipedia:<br><br><a href="http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes" target="_blank" rel="noreferrer noopener"><u>List of ISO-639-1 Codes on Wikipedia</u></a>',
        'type'     => 'text',
        'required' => true,
        'min'      => 5,
        'max'      => 5,
        'validate' => 'printable'
    );
    jrCore_form_field_create($_tmp);

    // New Lang Direction
    $_tmp = array(
        'name'     => 'new_lang_direction',
        'label'    => 'language text direction',
        'help'     => 'Does this new language flow from left to right (ltr) or from right to left (rtl)?',
        'type'     => 'select',
        'options'  => array('ltr' => 'Left to Right', 'rtl' => 'Right to Left'),
        'value'    => 'ltr',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
