<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_create_save($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_form_validate($_post);

    // Make sure they don't already exist
    $_rt = jrCore_db_get_item_by_key('jrUser', 'user_name', $_post['user_name']);
    if ($_rt && is_array($_rt)) {
        jrCore_set_form_notice('error', 33);
        jrCore_form_field_hilight('user_name');
        jrCore_form_result();
    }

    // Make sure they don't already exist
    $_rt = jrCore_db_get_item_by_key('jrUser', 'user_email', $_post['user_email']);
    if ($_rt && is_array($_rt)) {
        jrCore_set_form_notice('error', 34);
        jrCore_form_field_hilight('user_email');
        jrCore_form_result();
    }

    // Make sure user_name is not a banned word...
    if (jrCore_run_module_function('jrBanned_is_banned', 'name', $_post['user_name'])) {
        jrCore_set_form_notice('error', 55);
        jrCore_form_field_hilight('user_name');
        jrCore_form_result();
    }

    // Make sure the user_name is not being used by a profile
    if ($_post['create_profile'] == 'on') {

        $_rt = jrCore_db_get_item_by_key('jrProfile', 'profile_url', $_post['user_name']);
        if ($_rt && is_array($_rt)) {
            jrCore_set_form_notice('error', 33);
            jrCore_form_field_hilight('user_name');
            jrCore_form_result();
        }
        $_rt = jrCore_db_get_item_by_key('jrProfile', 'profile_name', $_post['user_name']);
        if ($_rt && is_array($_rt)) {
            jrCore_set_form_notice('error', 33);
            jrCore_form_field_hilight('user_name');
            jrCore_form_result();
        }

    }

    // Make sure it does not existing in the Recycle Bin
    if (jrUser_name_exists_in_recycle_bin($_post['user_name'])) {
        jrCore_set_form_notice('error', 33);
        jrCore_form_field_hilight('user_name');
        jrCore_form_result();
    }

    // Check for an active skin template with that name...
    if (is_file(APP_DIR . "/skins/{$_conf['jrCore_active_skin']}/{$_post['user_name']}.tpl")) {
        jrCore_set_form_notice('error', 33);
        jrCore_form_field_hilight('user_name');
        jrCore_form_result();
    }
    // Create profile or not
    $cusr = false;
    if (jrUser_is_admin()) {
        $cusr = $_post['create_profile'];
    }

    // See if we are generating a password
    if (isset($_post['user_passwd1']) && strlen($_post['user_passwd1']) > 0 && isset($_post['user_passwd2']) && strlen($_post['user_passwd2']) > 0) {
        if ($_post['user_passwd1'] != $_post['user_passwd2']) {
            jrCore_set_form_notice('error', 35);
            jrCore_form_field_hilight('user_passwd1');
            jrCore_form_field_hilight('user_passwd2');
            jrCore_form_result();
        }
    }
    else {
        // Create and generate a password
        $_post['user_passwd1'] = substr(md5(microtime() . mt_rand()), 8, 8);
    }
    $password = $_post['user_passwd1'];

    // Setup our default user values
    $pass = jrUser_get_password_hash($_post['user_passwd1']);
    $code = md5(microtime() . mt_rand());
    unset($_post['user_passwd1'], $_post['user_passwd2']);

    // Create our user account
    $_data = array(
        'user_name'      => $_post['user_name'],
        'user_email'     => $_post['user_email'],
        'user_group'     => 'user',
        'user_password'  => $pass,
        'user_language'  => (!empty($_post['user_language'])) ? $_post['user_language'] : $_conf['jrUser_default_language'],
        'user_active'    => 1,
        'user_validated' => 1,
        'user_validate'  => $code
    );
    // Check for master setting group
    if (jrUser_is_master()) {
        if (!empty($_post['user_group'])) {
            $_data['user_group'] = $_post['user_group'];
        }
    }

    $uid = jrCore_db_create_item('jrUser', $_data);
    if (!isset($uid) || !jrCore_checktype($uid, 'number_nz')) {
        jrCore_set_form_notice('error', 36);
        jrCore_form_result();
    }

    // User account is created - send out trigger so any listening
    // modules can do their work for this new user
    $_temp = array();
    $_core = array(
        '_user_id' => $uid
    );
    if ($cusr == 'off') {
        $_core['_profile_id'] = 0;  // hack but needed..
    }
    // Update account just created with proper user_id...
    jrCore_db_update_item('jrUser', $uid, $_temp, $_core);

    $_data['_user_id'] = $uid;
    $_data             = jrCore_trigger_event('jrUser', 'signup_created', $_data, $_data);

    // Send User Account email
    if (isset($_post['user_password_create']) && $_post['user_password_create'] == 'on') {
        $_rp = array(
            'system_name' => $_conf['jrCore_system_name'],
            'jamroom_url' => $_conf['jrCore_base_url'],
            'user_name'   => $_data['user_name'],
            'user_pass'   => $password,
            'user_email'  => $_data['user_email']
        );
        list($sub, $msg) = jrCore_parse_email_templates('jrUser', 'created', $_rp);
        jrCore_send_email($_data['user_email'], $sub, $msg);
        if ($cusr == 'off') {
            jrCore_set_form_notice('success', 'The account has been created and a welcome email sent.<br>You can now modify information about the Profile for this new User.', false);
        }
    }
    elseif ($cusr == 'off') {
        jrCore_set_form_notice('success', 'The User account has been successfully created.<br>You can now modify information about the Profile for this new User.', false);
    }

    // Our User Account is created...
    jrCore_logger('INF', "user: account created for {$_data['user_email']}");
    jrCore_form_delete_session();

    $purl = jrCore_get_module_url('jrProfile');
    if (jrUser_is_admin() && $cusr == 'off') {
        // Redirect to link up so User Account can be linked to profile...
        jrCore_set_form_notice('success', 'The User account has been successfully created.<br>Select the profile you would like to link to the User Account.<br><strong>The User will be unable to log in</strong> without a linked Profile!', false);
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$purl}/user_link/user_id={$uid}");
    }
    // Redirect to the Update Profile page so the admin can change anything needed
    $_usr = jrCore_db_get_item('jrUser', $uid, true); // OK
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$purl}/settings/profile_id={$_usr['_profile_id']}");
}
