<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: delete_language
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_delete_language($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrUser');
    jrCore_page_banner('delete user language');

    $_dl = jrUser_get_languages();
    $err = false;
    unset($_dl['en-US']);
    if (strlen(reset($_dl)) === 0) {
        jrCore_set_form_notice('error', 'There are no additional user languages install besides en-US.');
        $err = true;
    }
    else {
        jrCore_set_form_notice('notice', 'Deleting a language here will not remove it from any modules or skins that have defined it.<br>The next time an Integrity Check is run, these language strings could be reloaded.<br>You will need to remove the actual module or skin language files if they get reloaded.', false);
    }
    jrCore_get_form_notice();

    if (!$err) {
        // Form init
        $_tmp = array(
            'submit_value'     => 'delete language',
            'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
            'form_ajax_submit' => false,
            'submit_prompt'    => 'Are you sure you want to delete this language?'
        );
        jrCore_form_create($_tmp);

        // Delete Language
        $_tmp = array(
            'name'     => 'delete_lang',
            'label'    => 'language to delete',
            'help'     => 'Select the existing User Language you would like to clone to create the new User Language',
            'type'     => 'select',
            'options'  => $_dl,
            'required' => true
        );
        jrCore_form_field_create($_tmp);
    }
    else {
        jrCore_page_cancel_button('referrer');
    }
    jrCore_page_display();
}
