<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: notifications
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_notifications($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    $_lang = jrUser_load_lang_strings();

    // Get user info for what has been requested
    $_data = jrUser_get_requested_user_account_info();
    jrUser_account_tabs('notifications', $_data);

    $button = null;
    if (!empty($_data['profile_name'])) {
        $button = jrCore_page_button('account-tabs-profile-button', "@{$_data['profile_url']}", "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_data['profile_url']}')");
    }

    // See if all notifications have been disabled
    $disabled = false;
    if (isset($_data['user_notifications_disabled']) && $_data['user_notifications_disabled'] == 'on') {
        jrCore_set_form_notice('error', 95);
        $disabled = true;
    }

    // our page banner
    jrCore_page_banner(64, $button);

    // Form init
    $_tmp = array(
        'submit_value'     => $_lang['jrCore'][72],
        'cancel'           => 'referrer',
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // See if this is a profile admin
    if (isset($_data)) {

        // User ID we are modifying
        $_tmp = array(
            'name'     => 'user_id',
            'type'     => 'hidden',
            'value'    => $_data['_user_id'],
            'validate' => 'number_nz'
        );
        jrCore_form_field_create($_tmp);

        // Profile ID we are modifying
        $_tmp = array(
            'name'     => 'profile_id',
            'type'     => 'hidden',
            'value'    => $_data['_profile_id'],
            'validate' => 'number_nz'
        );
        jrCore_form_field_create($_tmp);
    }
    else {
        $_post['user_id']    = $_user['_user_id'];
        $_post['profile_id'] = $_user['_profile_id'];
    }

    // Disable all notifications
    $_tmp = array(
        'name'     => 'user_notifications_disabled',
        'type'     => 'checkbox',
        'label'    => 122,
        'help'     => 120,
        'validate' => 'onoff',
        'value'    => (isset($_data['user_notifications_disabled'])) ? $_data['user_notifications_disabled'] : 'off'
    );
    jrCore_form_field_create($_tmp);

    if (!isset($_data['user_notifications_disabled']) || $_data['user_notifications_disabled'] != 'on') {

        // Get our registered notification events
        $_htm = array();
        $_sel = array();
        $_tmp = jrCore_get_registered_module_features('jrUser', 'notification');

        if ($_tmp && is_array($_tmp)) {

            // Let other modules know what options we are doing
            $_tmp = jrCore_trigger_event('jrUser', 'notification_options', $_tmp, $_data);

            // We support disabling notifications + email
            $_opts = array(
                'off'   => $_lang['jrUser'][65],
                'email' => $_lang['jrUser'][66]
            );
            // Trigger event to let other modules add notification plugins
            $_opts = jrCore_trigger_event('jrUser', 'notification_plugins', $_opts, $_data);

            $layout = jrCore_get_config_value('jrUser', 'notification_layout', 'compact');
            foreach ($_tmp as $module => $_events) {
                foreach ($_events as $name => $label) {

                    // Trigger so modules can remove/adjust entries
                    $_args    = array(
                        'show'   => true,
                        'module' => $module,
                        'name'   => $name,
                        'data'   => $label
                    );
                    $_options = jrCore_trigger_event('jrUser', 'notification_event', $_opts, $_args);
                    if (isset($_options['show']) && jrCore_checktype($_options['show'], 'is_false')) {
                        // We are NOT showing this entry
                        continue;
                    }

                    // If this is an EMAIL ONLY event, disable everything else
                    if (isset($label['email_only']) && jrCore_checktype($label['email_only'], 'is_true')) {
                        foreach ($_options as $k => $v) {
                            if ($k != 'off' && $k != 'email') {
                                unset($_options[$k]);
                            }
                        }
                    }

                    $nid = "{$module}_{$name}";
                    if ($layout == 'expanded') {
                        $_htm[$nid] = '<div id="' . $nid . '">';
                    }
                    else {
                        $_htm[$nid] = '<div id="' . $nid . '" style="display:none">';
                    }
                    if (is_array($label)) {

                        // With our $label being an array we have some control over
                        // how this notification option will appear in the User Notifications
                        if (isset($label['function']) && function_exists($label['function'])) {
                            $func  = $label['function'];
                            $_args = array(
                                'module' => $module,
                                'event'  => $name,
                            );
                            if (!$func($_post, $_user, $_conf, $_args)) {
                                // Function has returned FALSE which means we do not show
                                continue;
                            }
                        }
                        else {

                            // See if this module defines a custom field to check for showing
                            if (isset($label['field']) && strlen($label['field']) > 0) {
                                if (isset($_data["{$label['field']}"]) && $_data["{$label['field']}"] != 'on') {
                                    continue;
                                }
                            }

                            // Check user group
                            if (!isset($label['group'])) {
                                $label['group'] = 'user';
                            }
                            switch ($label['group']) {
                                case 'master':
                                    if (!jrUser_is_master()) {
                                        continue 2;
                                    }
                                    break;
                                case 'admin':
                                    if (!jrUser_is_admin()) {
                                        continue 2;
                                    }
                                    break;
                                case 'power':
                                    if (!jrUser_is_power_user()) {
                                        continue 2;
                                    }
                                    break;
                                case 'multi':
                                    if (!jrUser_is_multi_user()) {
                                        continue 2;
                                    }
                                    break;
                                case 'all':
                                    break;
                                default:
                                    if (!isset($label['field']) && isset($_data["quota_{$module}_allowed"]) && $_data["quota_{$module}_allowed"] != 'on') {
                                        continue 2;
                                    }
                                    break;
                            }
                        }
                    }
                    else {
                        // Make sure this user has Quota access
                        if (isset($_data["quota_{$module}_allowed"]) && $_data["quota_{$module}_allowed"] != 'on') {
                            continue;
                        }
                    }

                    // If we have disabled all notifications, show that
                    if ($disabled) {
                        $_data["user_{$module}_{$name}_notifications"] = 'off';
                    }

                    $checked = 'email';  //default
                    if (isset($_data["user_{$module}_{$name}_notifications"])) {
                        $checked = $_data["user_{$module}_{$name}_notifications"];
                    }
                    elseif (!empty($_options['checked'])) {
                        $checked = $_options['checked'];
                    }
                    if (isset($_options['checked'])) {
                        unset($_options['checked']);
                    }
                    $_tmp = array(
                        'name'     => "event_{$module}_{$name}",
                        'type'     => 'radio',
                        'options'  => $_options,
                        'checked'  => $checked,
                        '_options' => $label
                    );
                    if (is_array($label)) {
                        $_tmp['label'] = ((isset($_lang[$module]["{$label['label']}"])) ? $_lang[$module]["{$label['label']}"] : $label['label']);
                        if (!empty($label['help'])) {
                            $_tmp['help'] = ((isset($_lang[$module]["{$label['help']}"])) ? $_lang[$module]["{$label['help']}"] : $label['help']);
                        }
                    }
                    else {
                        $_tmp['label'] = ((isset($_lang[$module][$label])) ? $_lang[$module][$label] : $label);
                    }

                    if (!isset($_sel[$nid])) {
                        $_sel[$nid] = ucwords($_tmp['label']);
                    }

                    $_htm[$nid] .= jrCore_parse_template('notification_option.tpl', $_tmp, 'jrUser') . '</div>';

                }
            }

            $html = '';
            natcasesort($_sel);
            if ($active = jrCore_get_cookie('nsel')) {
                jrCore_delete_cookie('nsel');
            }
            else {
                $active = array_flip($_sel);
                $active = reset($active);
            }
            $select = '<select id="user-notification-select" class="form_select" onchange="jrUser_notification_option($(this).val()); return false">';
            foreach ($_sel as $nid => $title) {
                if ($active == $nid) {
                    $select .= '<option value="' . $nid . '" selected="selected"> ' . $title . "</option>\n";
                    $html   .= str_replace('style="display:none"', 'class="no-act"', $_htm[$nid]);
                }
                else {
                    $select .= '<option value="' . $nid . '"> ' . $title . "</option>\n";
                    $html   .= $_htm[$nid];
                }
            }
            $select .= '</select>';
            if (!isset($_conf['jrUser_notification_layout']) || $_conf['jrUser_notification_layout'] != 'expanded') {
                jrCore_page_section_header($select);
            }
            jrCore_page_custom($html, '');
        }

    }
    jrCore_page_display();
}
