<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: notifications_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_notifications_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_form_validate($_post);

    // See if this is an admin modifying this user account
    $uid = $_user['_user_id'];
    if (jrUser_is_admin() && isset($_post['user_id']) && jrCore_checktype($_post['user_id'], 'number_nz')) {
        $uid = (int) $_post['user_id'];
    }
    $_up = array();
    $_dl = array();
    foreach ($_post as $k => $v) {
        if (strpos($k, 'event_') === 0) {
            $nam = 'user_' . substr($k, 6) . '_notifications';
            // Do not save unless it is NOT 'email'
            if ($v !== 'email') {
                $_up[$nam] = $v;
            }
            else {
                // Make sure it is REMOVED since email is the DEFAULT
                $_dl[] = $nam;
            }
            if (isset($uid) && $uid == $_user['_user_id']) {
                $_SESSION[$nam] = $v;
            }
        }
    }
    if (isset($_post['user_notifications_disabled']) && $_post['user_notifications_disabled'] == 'on') {
        $_up['user_notifications_disabled'] = 'on';
    }
    else {
        jrCore_db_delete_item_key('jrUser', $uid, 'user_notifications_disabled');
        jrUser_delete_session_key('user_notifications_disabled');
    }
    if (count($_up) > 0) {
        jrCore_db_update_item('jrUser', $uid, $_up, null, true, true, false);
    }
    if (count($_dl) > 0) {
        jrCore_db_delete_multiple_item_keys('jrUser', $uid, $_dl, false, true, false);
    }

    // Re-sync session
    if ($uid == $_user['_user_id']) {
        jrUser_reset_cache($uid);
        jrUser_session_sync();
    }
    else {
        jrUser_set_session_sync_for_user_id($uid, 'on');
    }

    jrCore_form_delete_session();
    jrCore_set_form_notice('success', 43);
    jrCore_form_result();
}
