<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: online
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_online($_post, $_user, $_conf)
{
    if (!jrUser_is_admin()) {
        jrUser_not_authorized();
    }
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrUser');

    // our page banner
    $btn = null;
    if (!isset($_conf['jrUser_bot_sessions']) || $_conf['jrUser_bot_sessions'] == 'on') {
        $url = jrCore_strip_url_params(jrCore_get_current_url(), array('show_bots'));
        if (isset($_post['show_bots'])) {
            $btn = jrCore_page_button('sb', 'Hide Bots', "jrCore_window_location('{$url}')");
        }
        else {
            $btn = jrCore_page_button('sb', 'Show Bots', "jrCore_window_location('{$url}/show_bots=1')");
        }
    }

    jrCore_page_banner('Users Online', $btn);
    jrCore_get_form_notice();

    jrUser_online_users($_post, $_user, $_conf);

    jrCore_page_display();
}
