<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: unsubscribe_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_unsubscribe_save($_post, $_user, $_conf)
{
    jrCore_form_validate($_post);
    if (!isset($_post['block_notifications']) || $_post['block_notifications'] != 'on') {
        jrCore_set_form_notice('error', 'Please confirm by checking the checkbox and submitting again. Thanks.');
        jrCore_location('referrer');
    }
    if (!isset($_post['user_validate']) || !jrCore_checktype($_post['user_validate'], 'md5')) {
        jrCore_set_form_notice('error', 'Invalid unique subscriber ID<br><br>Please make sure you are entering the full unsubscribe URL from the email (3)', false);
        jrCore_location('referrer');
    }
    if (!$_rt = jrCore_db_get_item_by_key('jrUser', 'user_validate', $_post['user_validate'], true)) {
        jrCore_set_form_notice('error', 'Invalid unique subscriber ID<br><br>Please make sure you are entering the full unsubscribe URL from the email (4)', false);
        jrCore_location('referrer');
    }
    // Unsubscribe the user
    $uid = (int) $_rt['_item_id'];
    $_up = array('user_notifications_disabled' => 'on');
    if (jrCore_db_update_item('jrUser', $uid, $_up)) {
        jrCore_db_delete_item_key('jrUser', $uid, 'user_unsubscribe');
        jrUser_reset_cache($uid);
        jrCore_logger('MIN', "user: {$_rt['user_name']} ({$_rt['user_email']}) has unsubscribed from all notifications", null, false);
        $_ln = jrUser_load_lang_strings();
        jrCore_notice_page('success', $_ln['jrUser'][94], jrCore_get_base_url(), $_ln['jrCore'][87]);
    }
    jrCore_set_form_notice('error', 'An error was encountered updating the database with the new notification preferences - please try again');
    jrCore_location('referrer');
}
