<?php
 /**
 * Jamroom Vimeo module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: integrity_check_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrVimeo_integrity_check_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_modal_notice('update', "verifying Vimeo videos");
    jrCore_form_modal_notice('update', "&nbsp;");

    // Get all uploaded Vimeo videos
    $_sp = array(
        'order_by'    => array('_item_id' => 'ASC'),
        'return_keys' => array('vimeo_id', 'vimeo_title'),
        'limit'       => 1000000
    );
    $_rt = jrCore_db_search_items('jrVimeo', $_sp);
    if (!empty($_rt['_items'])) {
        $checked = 0;
        $deleted = 0;
        foreach ($_rt['_items'] as $_vid) {
            if (!$_tmp = jrVimeo_api_request("/videos/{$_vid['vimeo_id']}")) {
                // No longer found
                jrCore_db_delete_item('jrVimeo', $_vid['_item_id']);
                jrCore_form_modal_notice('update', "'{$_vid['vimeo_title']}' not found on Vimeo - Deleted");
                $deleted++;
            }
            else {
                jrCore_form_modal_notice('update', "'{$_vid['vimeo_title']}' OK");
            }
            jrCore_start_timer('sleep');
            usleep(100000);
            jrCore_stop_timer('sleep');
            $checked++;
            if ($checked % 10 == 0) {
                jrCore_form_modal_notice('update', "{$checked} Vimeo videos checked");
            }
        }
        jrCore_form_modal_notice('update', "completed verification of {$checked} Vimeo IDs");
        jrCore_form_modal_notice('update', "{$deleted} Vimeo videos deleted");
    }
    else {
        jrCore_form_modal_notice('update', 'No Vimeo videos found');
    }
    jrCore_form_delete_session();
    jrCore_form_modal_notice('complete', 'The Vimeo integrity check successfully completed');
    jrCore_exit();
}
