<?php
 /**
 * Jamroom Vimeo module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: search_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrVimeo_search_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    // Validate all incoming posted data
    jrCore_form_validate($_post);

    // Import selected videos
    $cnt = 0;
    foreach ($_post as $k => $v) {
        if (substr($k, 0, 13) == 'import_video_' && $v == 'on') {
            $vid = substr($k, 13);
            if (jrCore_checktype($vid, 'number_nz')) {

                // Get data for video
                $_vt = jrVimeo_api_request("/videos/{$vid}");
                if ($_vt && is_array($_vt)) {

                    // Save data
                    $_rt = array(
                        'vimeo_id'          => $vid,
                        'vimeo_title'       => $_vt['name'],
                        'vimeo_title_url'   => jrCore_url_string($_vt['name']),
                        'vimeo_description' => $_vt['description'],
                        'vimeo_duration'    => jrCore_format_seconds($_vt['duration'])
                    );

                    // Do we have an image?
                    if (!empty($_vt['pictures']['sizes']) && is_array($_vt['pictures']['sizes'])) {

                        // Let's get the biggest image we can
                        if ($_tmp = array_reverse($_vt['pictures']['sizes'])) {
                            foreach ($_tmp as $_pic) {
                                if (isset($_pic['link'])) {
                                    if (!isset($_rt['vimeo_artwork_url'])) {
                                        $_rt['vimeo_artwork_url'] = $_pic['link'];
                                        break;
                                    }
                                }
                            }
                        }
                    }

                    // All good - Create item
                    $id = jrCore_db_create_item('jrVimeo', $_rt);
                    if (!$id) {
                        jrCore_set_form_notice('error', 51);
                        jrCore_form_result();
                    }

                    // Save thumbnail of video
                    if (isset($_rt['vimeo_artwork_url']) && jrCore_checktype($_rt['vimeo_artwork_url'], 'url')) {
                        $cdr = jrCore_get_module_cache_dir('jrVimeo');
                        $ext = jrCore_file_extension($_rt['vimeo_artwork_url']);
                        $fil = "{$cdr}/jrVimeo_vimeo_image_{$id}.{$ext}";
                        if (jrCore_download_file($_rt['vimeo_artwork_url'], $fil)) {
                            jrCore_save_media_file('jrVimeo', $fil, $_user['user_active_profile_id'], $id, 'vimeo_image');
                        }
                    }

                    // Add the FIRST VIDEO to our actions...
                    if (!isset($action_saved)) {
                        // Add to Actions...
                        jrCore_run_module_function('jrAction_save', 'search', 'jrVimeo', $id);
                        $action_saved = true;
                    }
                    $cnt++;

                    // See if we are creating tags
                    if (jrCore_module_is_active('jrTags') && isset($_post["import_tags_{$vid}"]) && $_post["import_tags_{$vid}"] == 'on') {
                        if (isset($_vt['tags']) && is_array($_vt['tags'])) {
                            foreach ($_vt['tags'] as $_tag) {
                                if (isset($_tag['tag'])) {
                                    $tag = trim($_tag['tag']);
                                    if (!empty($tag)) {
                                        jrTags_create_tag('jrVimeo', $_user['user_active_profile_id'], $id, $tag);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    jrCore_form_delete_session();

    if ($cnt > 0) {
        $_ln = jrUser_load_lang_strings();
        jrCore_set_form_notice('success', "{$cnt} {$_ln['jrVimeo'][34]}");
    }
    $svt = urlencode($_post['search_string']);
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/search/admin/search_string={$svt}/p={$_post['pn']}");
}
