<?php
 /**
 * Jamroom YouTube module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: integrity_check_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrYouTube_integrity_check_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_modal_notice('update', "verifying YouTube videos - please be patient");
    ini_set('max_execution_time', 82800); // 23 hours max

    // Get all uploaded YouTube videos
    $_rt = array(
        'return_keys'    => array('_item_id', 'youtube_id', 'youtube_artwork_url', 'youtube_duration', 'youtube_title'),
        'skip_triggers'  => true,
        'ignore_pending' => true,
        'limit'          => 1000000
    );
    $_rt = jrCore_db_search_items('jrYouTube', $_rt);
    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        $checked = 0;
        $deleted = 0;
        $updated = 0;
        foreach ($_rt['_items'] as $_vid) {
            $_tmp = jrYouTube_get_feed_data($_vid['youtube_id']);
            if ($_tmp == '404') {
                // No longer found
                jrCore_db_delete_item('jrYouTube', $_vid['_item_id']);
                jrCore_form_modal_notice('update', "Deleted &quot;{$_vid['youtube_title']}&quot; (ID {$_vid['_item_id']}) - not found on YouTube");
                $deleted++;
            }
            elseif (is_array($_tmp)) {
                $img = false;
                if (!empty($_tmp['thumbnail']['hqDefault'])) {
                    $img = $_tmp['thumbnail']['hqDefault'];
                }
                elseif (!empty($_tmp['thumbnail']['sqDefault'])) {
                    $img = $_tmp['thumbnail']['sqDefault'];
                }
                $dur = false;
                if (!empty($_tmp['duration'])) {
                    $dur = jrCore_format_seconds($_tmp['duration']);
                }
                if ($img && $dur && ((!empty($_vid['youtube_artwork_url']) && $_vid['youtube_artwork_url'] != $img) || (!empty($_vid['youtube_duration']) && $_vid['youtube_duration'] != $dur))) {
                    // We've got a different duration or image URL now - update
                    $_up = array(
                        'youtube_artwork_url' => $img,
                        'youtube_duration'    => $dur
                    );
                    jrCore_db_update_item('jrYouTube', $_vid['_item_id'], $_up, null, false, true, false);
                    jrCore_form_modal_notice('update', "Updated &quot;{$_vid['youtube_title']}&quot; (ID {$_vid['_item_id']})");
                    $updated++;
                }
            }
            usleep(100000);
            $checked++;
            if ($checked % 10 == 0) {
                jrCore_form_modal_notice('update', "{$checked} YouTube videos checked");
            }
        }
        jrCore_form_modal_notice('update', "completed verification of {$checked} YouTube IDs");
        jrCore_form_modal_notice('update', "{$updated} YouTube videos updated");
        jrCore_form_modal_notice('update', "{$deleted} YouTube videos deleted");
    }
    else {
        jrCore_form_modal_notice('update', 'No YouTube videos found');
    }
    jrCore_form_delete_session();
    jrCore_form_modal_notice('complete', 'The YouTube integrity check successfully completed');
    jrCore_exit();
}
