<?php
 /**
 * Jamroom YouTube module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: search
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrYouTube_search($_post, $_user, $_conf)
{
    jrUser_session_require_login();

    if (!isset($_conf['jrYouTube_v3_api_key']) || strlen($_conf['jrYouTube_v3_api_key']) < 5) {
        // need to set the YouTube v3 API
        jrCore_notice_page('notice', 'YouTube has changed their API.  Steps need to be taken by this sites administrator to make this module work again. <br>See here: <a target="_blank" href="https://www.jamroom.net/the-jamroom-network/documentation/modules/295/youtube-support#c2665">Connecting to the YouTube v3 API</a>', null, null, false);
    }

    // Get language strings
    $_lang = jrUser_load_lang_strings();

    // Start our create form
    jrCore_page_banner($_lang['jrYouTube'][22]);

    $ss = (isset($_post['ss']) && strlen($_post['ss']) > 0) ? strip_tags($_post['ss']) : $_user['profile_name'];
    $ss = trim($ss);
    if (!isset($_post['p']) || !jrCore_checktype($_post['p'], 'number_nz')) {
        $_post['p'] = 1;
    }
    if ($mr = jrCore_get_pager_rows()) {
        if ($mr > 100) {
            $mr = 100;
            jrCore_set_form_notice('error', "Max results for YouTube Search is 100");
        }
    }
    else {
        $mr = 10;
    }
    $_SESSION['jryoutube_saved_ss'] = $ss;

    // Search and pagebreak form
    $cancel = $_conf['jrCore_base_url'] . '/' . $_user['profile_url'] . '/' . $_post['module_url'];
    $_tmp   = array(
        'submit_value' => 23,
        'cancel'       => $cancel
    );
    $tok    = jrCore_form_create($_tmp);

    // Page number
    $_tmp = array(
        'name'  => 'p',
        'type'  => 'hidden',
        'value' => $_post['p']
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'       => 'ss',
        'label'      => 22,
        'help'       => 24,
        'type'       => 'text',
        'value'      => $ss,
        'validate'   => 'printable',
        'required'   => false,
        'onkeypress' => "if (event && event.keyCode == 13 && this.value.length > 0) { jrFormSubmit('#jrYouTube_search','{$tok}','ajax'); }"
    );
    jrCore_form_field_create($_tmp);

    // Get YT page
    $si = (($_post['p'] - 1) * $mr) + 1;
    $ss = urlencode($ss);

    // Get results
    $pt = '';
    if (isset($_SESSION['jrYouTubeSearch']["{$_post['p']}"])) {
        $pt = $_SESSION['jrYouTubeSearch']["{$_post['p']}"];
    }
    $yurl = "https://www.googleapis.com/youtube/v3/search?part=snippet&type=video&q={$ss}&maxResults={$mr}&pageToken={$pt}&key={$_conf['jrYouTube_v3_api_key']}";
    $temp = jrCore_load_url($yurl, null, 'GET', 443);
    if (!$temp || strlen($temp) === 0) {
        // Curl has failed - lets make sure and try it with file_get_contents instead
        $temp = file_get_contents($yurl);
    }
    $_tmp = json_decode($temp, true);
    if (jrUser_is_admin() && isset($_tmp['error']) && is_array($_tmp['error']) && isset($_tmp['error']['message'])) {
        jrCore_page_notice('error', $_tmp['error']['message']);
    }

    if ($_tmp && is_array($_tmp) && isset($_tmp['items']) && is_array($_tmp['items'])) {
        // Get youtube videos already imported
        $_sp  = array(
            'search'         => array(
                "_profile_id = {$_user['user_active_profile_id']}"
            ),
            'return_keys'    => array('youtube_id'),
            'privacy_check'  => false,
            'ignore_pending' => true
        );
        $_rt  = jrCore_db_search_items('jrYouTube', $_sp);
        $_ids = array();
        if (!empty($_rt['_items'])) {
            foreach ($_rt['_items'] as $_itm) {
                $_ids[$_itm['youtube_id']] = 1;
            }
        }

        // Display Results
        $dat             = array();
        $dat[1]['title'] = $_lang['jrYouTube'][29];
        $dat[1]['width'] = '20%';
        $dat[2]['title'] = $_lang['jrYouTube'][30];
        $dat[2]['width'] = '25%';
        $dat[3]['title'] = $_lang['jrYouTube'][31];
        $dat[3]['width'] = '50%';
        $dat[4]['title'] = $_lang['jrYouTube'][32];
        $dat[4]['width'] = '5%';
        jrCore_page_table_header($dat);

        $p   = jrCore_get_server_protocol();
        $alt = jrCore_entity_string($_lang['jrYouTube'][29]);
        foreach ($_tmp['items'] as $k => $_vid) {
            $dat             = array();
            $dat[1]['title'] = "<div id=\"h{$k}\"><img src=\"{$_vid['snippet']['thumbnails']['medium']['url']}\" style=\"height:123px;cursor:pointer\" onclick=\"$('#h{$k}').html('<iframe id=&quot;v{$k}&quot; type=&quot;text/html&quot; width=&quot;100%&quot; height=&quot;120&quot; src=&quot;{$p}://www.youtube.com/embed/{$_vid['id']['videoId']}?autoplay=1&quot; frameborder=&quot;0&quot;></iframe>')\" alt=\"{$alt}\"></div>";
            $dat[1]['class'] = 'center';

            $date = date_create($_vid['snippet']['publishedAt']);
            $date = date_format($date, 'Y-m-d');

            $dat[2]['title'] = "<h3>{$_vid['snippet']['title']}</h3><br><strong>{$_lang['jrYouTube'][56]}:</strong> {$_vid['snippet']['channelTitle']}<br><strong>{$_lang['jrYouTube'][50]}:</strong> {$date}<br>";
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = (isset($_vid['snippet']['description'])) ? jrCore_string_to_url(jrCore_strip_html($_vid['snippet']['description'])) : '';
            if (isset($_ids["{$_vid['id']['videoId']}"])) {
                $dat[4]['title'] = '&nbsp;';
            }
            else {
                $dat[4]['title'] = '<input class="ytiv" type="checkbox" name="import_video_' . $_vid['id']['videoId'] . '">';
                $dat[4]['class'] = 'center';
            }
            jrCore_page_table_row($dat);
        }
        $dat             = array();
        $dat[1]['title'] = $_lang['jrYouTube'][39];
        $dat[1]['class'] = 'right" colspan="3';
        $dat[2]['title'] = '<input type="checkbox" onclick="$(\'.ytiv\').prop(\'checked\',$(this).prop(\'checked\'));">';
        $dat[2]['class'] = 'center';
        jrCore_page_table_row($dat);

        $_pg = array('info' => array(
            // page jumper select doesnt work, so disabling this.
            // 'total_pages' => (int) round($_tmp['pageInfo']['totalResults'] / $_tmp['pageInfo']['resultsPerPage']),
            'simplepagebreak' => true,
            'this_page'       => $_post['p'],
            'next_page'       => ($_post['p'] + 1),
            'prev_page'       => ($_post['p'] < 2) ? 0 : ($_post['p'] - 1)
        ));

        $_xt = array();
        if (isset($_tmp['prevPageToken']) && strlen($_tmp['prevPageToken']) > 2) {
            $_xt["{$_pg['info']['prev_page']}"] = $_tmp['prevPageToken'];
        }
        if (isset($_tmp['nextPageToken']) && strlen($_tmp['nextPageToken']) > 2) {
            $_xt["{$_pg['info']['next_page']}"] = $_tmp['nextPageToken'];
        }
        $_SESSION['jrYouTubeSearch'] = $_xt;

        jrCore_page_table_pager($_pg);
        jrCore_page_table_footer();
    }
    else {
        jrCore_page_notice('notice', $_lang['jrYouTube'][33] . ': ' . jrCore_entity_string($ss));
    }
    jrCore_page_display();
}
