<?php
 /**
 * Jamroom YouTube module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: search_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrYouTube_search_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);

    // Import selected videos
    $cnt = 0;
    foreach ($_post as $k => $v) {
        if (substr($k, 0, 13) == 'import_video_' && $v == 'on') {
            $yid = substr($k, 13);
            if (strlen($yid) == 11 && jrCore_checktype($yid, 'url_name')) {
                $_tmp = jrYouTube_get_feed_data($yid);
                if ($_tmp && is_array($_tmp)) {
                    $_tmp = array(
                        'youtube_id'           => $yid,
                        'youtube_title'        => $_tmp['title'],
                        'youtube_title_url'    => jrCore_url_string($_tmp['title']),
                        'youtube_category'     => $_tmp['category'],
                        'youtube_category_url' => jrCore_url_string($_tmp['category']),
                        'youtube_description'  => $_tmp['description'],
                        'youtube_artwork_url'  => (isset($_tmp['thumbnail']['hqDefault'])) ? $_tmp['thumbnail']['hqDefault'] : $_tmp['thumbnail']['sqDefault'],
                        'youtube_duration'     => jrCore_format_seconds($_tmp['duration'])
                    );
                    $id   = jrCore_db_create_item('jrYouTube', $_tmp);
                    if ($id) {
                        // Add the FIRST VIDEO to our actions...
                        if (!isset($action_saved)) {
                            // Add to Actions...
                            $_tmp['action_original_module']  = 'jrYouTube';
                            $_tmp['action_original_item_id'] = $id;
                            jrCore_run_module_function('jrAction_save', 'search', 'jrYouTube', $id, $_tmp);
                            $action_saved = true;
                        }
                        $cnt++;
                    }
                }
            }
        }
    }
    jrCore_form_delete_session();
    if ($cnt > 0) {
        $_lang = jrUser_load_lang_strings();
        jrCore_set_form_notice('success', "{$cnt} {$_lang['jrYouTube'][34]}");
        jrProfile_reset_cache();
    }

    // Refresh with options
    $ss = (isset($_post['ss']) && strlen($_post['ss']) > 0) ? strip_tags($_post['ss']) : $_user['profile_name'];
    jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/search/ss={$ss}");
}
