<?php
 /**
 * Jamroom jrSoloPro skin
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this skin.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2017 The Jamroom Network - All Rights Reserved
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * jrSoloPro_skin_config
 */
function jrSoloPro_skin_config()
{
    $styles = array('light', 'dark');

    // Style
    $_tmp = array(
        'name'     => "style",
        'type'     => 'select',
        'default'  => 'light',
        'options'  => $styles,
        'validate' => 'printable',
        'label'    => "Skin Style",
        'help'     => "Video Pro includes an alternative dark style.",
        'section'  => 'General',
        'order'    => 0,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    $_tmp = array(
        'name'     => 'auto_play',
        'default'  => 'off',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'label'    => 'Auto Play',
        'help'     => 'If this box is checked your players will play when loaded.',
        'order'    => 1,
        'section'  => 'General'
    );
    jrCore_register_setting('jrSoloPro',$_tmp);

    // Forum Profile
    $_tmp = array(
        'name'     => 'forum_profile',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'url',
        'label'    => 'Forum Profile URL',
        'sublabel' => 'Check the help section.',
        'help'     => 'If you have a Site Forum, enter the <b>Full URL</b> to the forum (usually the site admin Profile URL)<br><br><b>Note:</b> If you are using Site Builder, add the Discussion Link via the Site Builder menu manager',
        'section'  => 'General',
        'order'    => 2,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


    // Section Active
    $_tmp = array(
        'name'     => "featured_video_active",
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => "Active",
        'help'     => "If this box is checked your featured video will appear.",
        'section'  => 'Featured Video',
        'order'    => 1
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video
    $_tmp = array(
        'name'     => 'featured_video_id',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'number_nz',
        'label'    => 'Featured Video ID',
        'sublabel' => 'required if active',
        'help'     => 'Insert comma separated video IDs for the Staff Picks list.',
        'section'  => 'Featured Video',
        'order'    => 2,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video Album
    $_tmp = array(
        'name'     => 'featured_song_id',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'number_nz',
        'label'    => 'Featured Album Song ID',
        'sublabel' => 'optional',
        'help'     => 'Insert the item ID of any song in the featured album.',
        'section'  => 'Featured Video',
        'order'    => 3,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Section Active
    $_tmp = array(
        'name'     => "calendar_active",
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => "Active",
        'help'     => "If this box is checked your featured video will appear.",
        'section'  => 'Calendar',
        'order'    => 10
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video
    $_tmp = array(
        'name'     => 'calendar_title',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'printable',
        'label'    => 'Calendar Title',
        'sublabel' => 'required if active',
        'help'     => 'Enter a title for the featured calendar.',
        'section'  => 'Calendar',
        'order'    => 11,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video Album
    $_tmp = array(
        'name'     => 'calendar_profile_id',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'number_nz',
        'label'    => 'Profile ID',
        'sublabel' => 'optional',
        'help'     => 'Insert the profile ID associated with this calendar. If it is left empty, events from all profiles will be available.',
        'section'  => 'Calendar',
        'order'    => 12,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Section Active
    $_tmp = array(
        'name'     => "album_listen_active",
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => "Active",
        'help'     => "If this box is checked your listen album will appear.",
        'section'  => 'Album Listen',
        'order'    => 20
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video
    $_tmp = array(
        'name'     => 'album_listen_song_id',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'number_nz',
        'label'    => 'Album Song ID',
        'sublabel' => 'required if active',
        'help'     => 'Enter any song ID from the album and the entire album will appear.',
        'section'  => 'Album Listen',
        'order'    => 21,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Section Active
    $_tmp = array(
        'name'     => "merchandise_active",
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => "Active",
        'help'     => "If this box is checked your listen album will appear.",
        'section'  => 'Merchandise',
        'order'    => 30
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video
    $_tmp = array(
        'name'     => 'merchandise_ids',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'printable',
        'label'    => 'Merchandise IDs',
        'sublabel' => 'optional',
        'help'     => 'Enter a comma separated list of product IDs. Limit: 4.',
        'section'  => 'Merchandise',
        'order'    => 31,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video
    $_tmp = array(
        'name'     => 'merchandise_profile_id',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'number_nz',
        'label'    => 'Profile ID',
        'sublabel' => 'optional',
        'help'     => 'Enter the profile ID for this list. If it is left empty, products from all profiles will be available',
        'section'  => 'Merchandise',
        'order'    => 32,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Section Active
    $_tmp = array(
        'name'     => "gallery_active",
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => "Active",
        'help'     => "If this box is checked your gallery will appear.",
        'section'  => 'Gallery',
        'order'    => 40
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video
    $_tmp = array(
        'name'     => 'gallery_profile_id',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'printable',
        'label'    => 'Gallery Profile ID',
        'sublabel' => 'optional',
        'help'     => 'Enter the profile ID for this list. If it is left empty, galleries from all profiles will be available.',
        'section'  => 'Gallery',
        'order'    => 41,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Section Active
    $_tmp = array(
        'name'     => "blog_active",
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => "Active",
        'help'     => "If this box is checked your featured blog will appear.",
        'section'  => 'Blog',
        'order'    => 50
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video
    $_tmp = array(
        'name'     => 'blog_ids',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'printable',
        'label'    => 'Blog IDs',
        'sublabel' => 'optional',
        'help'     => 'Enter a comma separated list of blog IDs. Limit: 2',
        'section'  => 'Blog',
        'order'    => 51,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);

    // Featured Video Album
    $_tmp = array(
        'name'     => 'blog_profile_id',
        'default'  => '',
        'type'     => 'text',
        'validate' => 'number_nz',
        'label'    => 'Profile ID',
        'sublabel' => 'optional',
        'help'     => 'Insert the profile ID associated with this list. If it is left empty, blog entries from all profiles will be available',
        'section'  => 'Blog',
        'order'    => 52,
    );
    jrCore_register_setting('jrSoloPro', $_tmp);


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


    // Social Media
    $num = 220;
    foreach (array('twitter', 'facebook', 'instagram', 'youtube', 'linkedin') as $network) {

        // App Store URL
        $_tmp = array(
            'name'     => "{$network}_url",
            'type'     => 'text',
            'default'  => '#',
            'validate' => 'printable',
            'label'    => ucfirst($network) . " page",
            'help'     => "If you have an account for your site on " . ucfirst(str_replace('_', ' ', $network)) .", enter the page url, page name or page ID.  Enter 0 to disable.",
            'order'    => $num++,
            'section'  => 'social'
        );
        jrCore_register_setting('jrSoloPro', $_tmp);

        jrCore_delete_setting('jrSoloPro','google_url');
    }

    return true;
}
